/*
 * Decompiled with CFR 0.152.
 */
package net.crazy.badges.core.ui.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.crazy.badges.api.Badge;
import net.crazy.badges.core.AddonConfiguration;
import net.crazy.badges.core.BadgesAddon;
import net.labymod.api.Laby;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.laby3d.renderer.snapshot.AbstractLabySnapshot;
import net.labymod.api.laby3d.renderer.snapshot.Extras;

public class BadgePlayerSnapshot
extends AbstractLabySnapshot {
    private final UUID uuid;
    private final List<Badge> badges;
    private final boolean enabled;
    private final boolean compactBadges;
    private final boolean showOnBadges;

    public BadgePlayerSnapshot(Player player, Extras extras, BadgesAddon addon) {
        super(extras);
        this.uuid = player.getUniqueId();
        this.badges = BadgesAddon.badgeManager().getPlayerBadges(player);
        this.enabled = (Boolean)((AddonConfiguration)addon.configuration()).enabled().get();
        this.compactBadges = (Boolean)((AddonConfiguration)addon.configuration()).compactBadges().get();
        this.showOnBadges = (Boolean)((AddonConfiguration)addon.configuration()).showOwn().get();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasBadges() {
        return !this.badges.isEmpty();
    }

    public boolean passesSelfCheck() {
        return this.showOnBadges || !this.uuid.equals(Laby.labyAPI().getUniqueId());
    }

    public List<Badge> getBadges() {
        if (!this.compactBadges) {
            return this.badges;
        }
        ArrayList<Badge> badges = new ArrayList<Badge>(this.badges);
        badges.removeIf(badge -> badge.getId() == 9 && this.hasBadge(badges, 10));
        badges.removeIf(badge -> badge.getId() == 10 && this.hasBadge(badges, 11));
        badges.removeIf(badge -> badge.getId() == 11 && this.hasBadge(badges, 13));
        return badges;
    }

    private boolean hasBadge(List<Badge> badges, int id) {
        for (Badge badge : badges) {
            if (badge.getId() != id) continue;
            return true;
        }
        return false;
    }
}

