/*
 * Decompiled with CFR 0.152.
 */
package net.crazy.badges.core.ui.tag;

import java.util.ArrayList;
import java.util.List;
import net.crazy.badges.api.Badge;
import net.crazy.badges.core.AddonConfiguration;
import net.crazy.badges.core.BadgesAddon;
import net.crazy.badges.core.ui.snapshot.BadgePlayerSnapshot;
import net.crazy.badges.core.ui.snapshot.BadgesExtraKeys;
import net.labymod.api.client.entity.player.tag.renderer.AbstractTagRenderer;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import net.labymod.api.laby3d.render.queue.SubmissionCollector;
import net.labymod.api.laby3d.render.queue.submissions.IconSubmission;

public class BadgeTag
extends AbstractTagRenderer {
    private static final float ICON_SIZE = 4.0f;
    private final AddonConfiguration config;
    private List<Icon> icons;
    private float width;
    private float height;

    public BadgeTag(BadgesAddon addon) {
        this.config = (AddonConfiguration)addon.configuration();
    }

    public void begin(EntitySnapshot snapshot) {
        super.begin(snapshot);
        this.icons = this.getIcons(snapshot);
        this.width = 4.0f * (float)this.icons.size();
        this.height = 4.0f;
    }

    private List<Icon> getIcons(EntitySnapshot snapshot) {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        if (!snapshot.has(BadgesExtraKeys.BADGE_PLAYER) || snapshot.isDiscrete() || snapshot.isInvisible()) {
            return icons;
        }
        BadgePlayerSnapshot badgePlayer = (BadgePlayerSnapshot)((Object)snapshot.get(BadgesExtraKeys.BADGE_PLAYER));
        if (!(badgePlayer.isEnabled() && badgePlayer.passesSelfCheck() && badgePlayer.hasBadges())) {
            return icons;
        }
        for (Badge badge : badgePlayer.getBadges()) {
            icons.add(badge.getIcon());
        }
        return icons;
    }

    public void render(Stack stack, SubmissionCollector submissionCollector, EntitySnapshot snapshot) {
        float x = 0.0f;
        for (Icon icon : this.icons) {
            submissionCollector.submitIcon(stack, icon, IconSubmission.DisplayMode.NORMAL, x, 0.0f, 4.0f, 4.0f, -1);
            x += 4.0f;
        }
    }

    public boolean isVisible() {
        return !this.icons.isEmpty();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getScale() {
        return 2.0f + (float)((Integer)this.config.size().get() - 1) * 5.0f / 9.0f;
    }
}

