/*
 * Decompiled with CFR 0.152.
 */
package net.crazy.badges.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Singleton;
import net.crazy.badges.api.Badge;
import net.crazy.badges.api.BadgeManager;
import net.labymod.api.models.Implements;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.GsonRequest;
import org.jetbrains.annotations.NotNull;

@Singleton
@Implements(value=BadgeManager.class)
public class DefaultBadgeManager
implements BadgeManager {
    private static final String BADGES_ENDPOINT = "https://laby.net/api/v3/badges";
    private final List<Badge> badges = new ArrayList<Badge>();
    private final Map<UUID, List<Badge>> playerBadges = new HashMap<UUID, List<Badge>>();

    @Override
    @NotNull
    public List<Badge> getPlayerBadges(UUID uuid) {
        if (this.playerBadges.containsKey(uuid)) {
            return Collections.unmodifiableList(this.playerBadges.get(uuid));
        }
        ArrayList<Badge> playerBadges = new ArrayList<Badge>();
        for (Badge badge : this.badges) {
            if (badge.getId() == 1 || badge.getId() == 3 || !badge.players().contains(uuid)) continue;
            playerBadges.add(badge);
        }
        this.playerBadges.put(uuid, playerBadges);
        return this.getPlayerBadges(uuid);
    }

    @Override
    public void removeFromPlayerCache(UUID uuid) {
        this.playerBadges.remove(uuid);
    }

    @Override
    public void clearPlayerCache() {
        this.playerBadges.clear();
    }

    @Override
    @NotNull
    public List<Badge> getBadges() {
        return Collections.unmodifiableList(this.badges);
    }

    @Override
    public void cacheBadges() {
        ((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonElement.class).url(BADGES_ENDPOINT, new Object[0])).handleErrorStream()).async(true)).execute(this::handleResponse);
    }

    private void handleResponse(Response<JsonElement> response) {
        try {
            if (response.hasException()) {
                throw new IllegalStateException((Throwable)response.exception());
            }
            if (response.isEmpty()) {
                throw new IllegalStateException("Response is empty");
            }
            JsonElement element = (JsonElement)response.get();
            if (!element.isJsonArray()) {
                throw new IllegalStateException("Response is not an array");
            }
            this.badges.clear();
            JsonArray entries = element.getAsJsonArray();
            for (int i = 0; i < entries.size(); ++i) {
                JsonObject object = entries.get(i).getAsJsonObject();
                int id = object.get("id").getAsInt();
                UUID uuid = UUID.fromString(object.get("uuid").getAsString());
                String name = object.get("name").getAsString();
                String description = object.get("description").getAsString();
                Badge badge = new Badge(id, uuid, name, description);
                this.badges.add(badge);
            }
            this.badges.sort(Comparator.comparingInt(Badge::getId));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

