/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends;

import com.rappytv.betterfriends.api.generated.ReferenceStorage;
import com.rappytv.betterfriends.command.BetterFriendsCommand;
import com.rappytv.betterfriends.config.BetterFriendsConfig;
import com.rappytv.betterfriends.interactions.FriendNoteEditorBullet;
import com.rappytv.betterfriends.interactions.FriendTogglePinBullet;
import com.rappytv.betterfriends.listeners.ChatReceiveListener;
import com.rappytv.betterfriends.listeners.FriendAddListener;
import com.rappytv.betterfriends.listeners.FriendRemoveListener;
import com.rappytv.betterfriends.listeners.FriendRequestReceiveListener;
import com.rappytv.betterfriends.listeners.FriendRequestRemoveListener;
import com.rappytv.betterfriends.listeners.FriendServerStateListener;
import com.rappytv.betterfriends.listeners.FriendStatusUpdateListener;
import com.rappytv.betterfriends.listeners.LabyChatReceiveListener;
import com.rappytv.betterfriends.ui.badge.FriendPinBadge;
import com.rappytv.betterfriends.ui.hud.FriendCountHudWidget;
import com.rappytv.betterfriends.ui.hud.IncomingFriendRequestCountHudWidget;
import com.rappytv.betterfriends.ui.hud.OnlineFriendCountHudWidget;
import com.rappytv.betterfriends.ui.hud.UnreadChatCountWidget;
import com.rappytv.betterfriends.ui.tags.FriendNoteNameTag;
import com.rappytv.betterfriends.ui.tags.FriendPinIconTag;
import com.rappytv.betterfriends.utils.GroupHelper;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import net.labymod.api.client.entity.player.badge.PositionType;
import net.labymod.api.client.entity.player.badge.renderer.BadgeRenderer;
import net.labymod.api.client.entity.player.tag.renderer.TagRenderer;
import net.labymod.api.client.gui.hud.binding.category.HudWidgetCategory;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.revision.Revision;
import net.labymod.api.revision.SimpleRevision;
import net.labymod.api.util.Color;
import net.labymod.api.util.version.SemanticVersion;

@AddonMain
public class BetterFriendsAddon
extends LabyAddon<BetterFriendsConfig> {
    private static final LegacyComponentSerializer SERIALIZER = LegacyComponentSerializer.legacyAmpersand();
    private static BetterFriendsAddon instance;

    protected void preConfigurationLoad() {
        Laby.references().revisionRegistry().register((Revision)new SimpleRevision("betterfriends", new SemanticVersion(1, 0, 1), "2025-12-10"));
    }

    protected void enable() {
        instance = this;
        this.registerSettingCategory();
        GroupHelper.registerGroupIds();
        this.registerCommand(new BetterFriendsCommand());
        this.registerListener(new ChatReceiveListener(this));
        this.registerListener(new FriendAddListener(this));
        this.registerListener(new FriendRemoveListener(this));
        this.registerListener(new FriendRequestReceiveListener(this));
        this.registerListener(new FriendRequestRemoveListener(this));
        this.registerListener(new FriendServerStateListener(this));
        this.registerListener(new FriendStatusUpdateListener(this));
        this.registerListener(new LabyChatReceiveListener(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new FriendNoteEditorBullet(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new FriendTogglePinBullet(this));
        HudWidgetCategory category = new HudWidgetCategory((Object)this, "widgets");
        this.labyAPI().hudWidgetRegistry().categoryRegistry().register((Object)category);
        this.labyAPI().hudWidgetRegistry().register((Object)new FriendCountHudWidget(category));
        this.labyAPI().hudWidgetRegistry().register((Object)new IncomingFriendRequestCountHudWidget(category));
        this.labyAPI().hudWidgetRegistry().register((Object)new OnlineFriendCountHudWidget(category));
        this.labyAPI().hudWidgetRegistry().register((Object)new UnreadChatCountWidget(category));
        for (net.labymod.api.client.entity.player.tag.PositionType position : net.labymod.api.client.entity.player.tag.PositionType.values()) {
            this.labyAPI().tagRegistry().registerBefore("labymod_role", "betterfriends_friend_note", position, (TagRenderer)new FriendNoteNameTag(this, position));
        }
        this.labyAPI().tagRegistry().registerBefore("VoiceTag", "betterfriends_pin_icon", net.labymod.api.client.entity.player.tag.PositionType.RIGHT_TO_NAME, (TagRenderer)new FriendPinIconTag());
        Laby.references().badgeRegistry().registerBefore("VoiceBadge", "betterfriends_pin_badge", PositionType.RIGHT_TO_NAME, (BadgeRenderer)new FriendPinBadge(this));
    }

    protected Class<? extends BetterFriendsConfig> configurationClass() {
        return BetterFriendsConfig.class;
    }

    public static ReferenceStorage references() {
        return (ReferenceStorage)instance.referenceStorageAccessor();
    }

    public static TextComponent getPrefix() {
        return (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"BF", (TextColor)TextColor.color((int)((Color)((BetterFriendsConfig)instance.configuration()).prefixColor().get()).get())).decorate(TextDecoration.BOLD))).append((Component)Component.space())).append((Component)Component.text((String)"\u00bb", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.space());
    }

    public LegacyComponentSerializer getSerializer() {
        return SERIALIZER;
    }
}

