/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.command;

import com.rappytv.betterfriends.BetterFriendsAddon;
import com.rappytv.betterfriends.listeners.LabyChatReceiveListener;
import com.rappytv.betterfriends.utils.GroupHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.chat.command.SubCommand;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.network.server.ServerInfo;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.labyconnect.protocol.model.User;
import net.labymod.api.labyconnect.protocol.model.chat.Chat;
import net.labymod.api.labyconnect.protocol.model.chat.ChatMessage;
import net.labymod.api.labyconnect.protocol.model.chat.TextChatMessage;
import net.labymod.api.labyconnect.protocol.model.request.IncomingFriendRequest;

public class BetterFriendsCommand
extends Command {
    public BetterFriendsCommand() {
        super("betterfriends", new String[]{"bf"});
        this.translationKey("betterfriends.command");
        this.withSubCommand(new AcceptFriendRequestSubcommand());
        this.withSubCommand(new DeclineFriendRequestSubcommand());
        this.withSubCommand(new JoinServerSubcommand());
        this.withSubCommand(new MessageSubcommand());
        this.withSubCommand(new ReadSubcommand());
    }

    public boolean execute(String prefix, String[] arguments) {
        ArrayList<String> subCommands = new ArrayList<String>();
        for (SubCommand subCommand : this.getSubCommands()) {
            subCommands.add(subCommand.getPrefix());
        }
        this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("usage"), (TextColor)NamedTextColor.RED, (Component[])new Component[]{Component.text((String)("/" + prefix + " <" + String.join((CharSequence)"/", subCommands) + ">"), (TextColor)NamedTextColor.AQUA)})));
        return true;
    }

    public static class AcceptFriendRequestSubcommand
    extends SubCommand {
        protected AcceptFriendRequestSubcommand() {
            super("accept", new String[0]);
            this.translationKey("betterfriends.command.requests");
        }

        public boolean execute(String prefix, String[] arguments) {
            if (arguments.length < 1) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("enterName"), (TextColor)NamedTextColor.RED)));
                return true;
            }
            LabyConnectSession session = Laby.references().labyConnect().getSession();
            if (session == null) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)"betterfriends.errors.notConnected", (TextColor)NamedTextColor.RED)));
                return true;
            }
            List requests = session.getIncomingRequests();
            for (IncomingFriendRequest request : requests) {
                if (!request.getName().equalsIgnoreCase(arguments[0])) continue;
                request.accept();
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("success.accept"), (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{GroupHelper.getColoredName(request.getName(), request.gameUser())})));
                return true;
            }
            this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("notFound"), (TextColor)NamedTextColor.RED)));
            return true;
        }
    }

    public static class DeclineFriendRequestSubcommand
    extends SubCommand {
        protected DeclineFriendRequestSubcommand() {
            super("decline", new String[0]);
            this.translationKey("betterfriends.command.requests");
        }

        public boolean execute(String prefix, String[] arguments) {
            if (arguments.length < 1) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("enterName"), (TextColor)NamedTextColor.RED)));
                return true;
            }
            LabyConnectSession session = Laby.references().labyConnect().getSession();
            if (session == null) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)"betterfriends.errors.notConnected", (TextColor)NamedTextColor.RED)));
                return true;
            }
            List requests = session.getIncomingRequests();
            for (IncomingFriendRequest request : requests) {
                if (!request.getName().equalsIgnoreCase(arguments[0])) continue;
                request.decline();
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("success.decline"), (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{GroupHelper.getColoredName(request.getName(), request.gameUser())})));
                return true;
            }
            this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("notFound"), (TextColor)NamedTextColor.RED)));
            return true;
        }
    }

    public static class JoinServerSubcommand
    extends SubCommand {
        protected JoinServerSubcommand() {
            super("join", new String[0]);
            this.translationKey("betterfriends.command.join");
        }

        public boolean execute(String prefix, String[] arguments) {
            if (arguments.length < 1) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("enterAddress"), (TextColor)NamedTextColor.RED)));
                return true;
            }
            this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("connecting"), (Component[])new Component[0])));
            Laby.references().serverController().joinServer(ServerInfo.builder().address(arguments[0]).build());
            return true;
        }
    }

    public static class MessageSubcommand
    extends SubCommand {
        protected MessageSubcommand() {
            super("message", new String[]{"msg"});
            this.translationKey("betterfriends.command.message");
        }

        public boolean execute(String prefix, String[] arguments) {
            if (arguments.length < 1) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("enterName"), (TextColor)NamedTextColor.RED)));
                return true;
            }
            LabyConnectSession session = Laby.references().labyConnect().getSession();
            if (session == null) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)"betterfriends.errors.notConnected", (TextColor)NamedTextColor.RED)));
                return true;
            }
            List chats = session.getChats();
            for (Chat chat : chats) {
                boolean containsUser = false;
                for (User user : chat.getParticipants()) {
                    if (!user.getName().equalsIgnoreCase(arguments[0])) continue;
                    containsUser = true;
                }
                if (!containsUser) continue;
                if (arguments.length < 2) {
                    this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("enterText"), (TextColor)NamedTextColor.RED)));
                    return true;
                }
                String message = String.join((CharSequence)" ", Arrays.copyOfRange(arguments, 1, arguments.length));
                chat.sendMessage(message);
                for (ChatMessage msg : chat.getMessages()) {
                    if (msg.isRead()) continue;
                    msg.markAsRead();
                }
                return true;
            }
            this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("notFound"), (TextColor)NamedTextColor.RED)));
            return true;
        }
    }

    public static class ReadSubcommand
    extends SubCommand {
        protected ReadSubcommand() {
            super("read", new String[0]);
            this.translationKey("betterfriends.command.read");
        }

        public boolean execute(String prefix, String[] arguments) {
            UUID uuid;
            if (Laby.references().labyConnect().getSession() == null) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)"betterfriends.errors.notConnected", (TextColor)NamedTextColor.RED)));
                return true;
            }
            if (arguments.length < 1) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("manual"), (TextColor)NamedTextColor.RED)));
                return true;
            }
            try {
                uuid = UUID.fromString(arguments[0]);
            }
            catch (IllegalArgumentException e) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("manual"), (TextColor)NamedTextColor.RED)));
                return true;
            }
            TextChatMessage message = LabyChatReceiveListener.getMessage(uuid);
            if (message == null) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("manual"), (TextColor)NamedTextColor.RED)));
                return true;
            }
            if (message.isRead()) {
                this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("alreadyRead"), (TextColor)NamedTextColor.RED)));
                return true;
            }
            message.markAsRead();
            this.displayMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)this.getTranslationKey("success"), (Component[])new Component[0])));
            return true;
        }
    }
}

