/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.listeners;

import com.rappytv.betterfriends.BetterFriendsAddon;
import com.rappytv.betterfriends.config.BetterFriendsConfig;
import com.rappytv.betterfriends.utils.GroupHelper;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.labymod.labyconnect.session.friend.LabyConnectFriendServerEvent;
import net.labymod.api.labyconnect.protocol.model.friend.Friend;
import net.labymod.api.labyconnect.protocol.model.friend.ServerInfo;
import net.labymod.api.util.time.TimeUtil;

public class FriendServerStateListener {
    private final BetterFriendsAddon addon;

    public FriendServerStateListener(BetterFriendsAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onServerUpdate(LabyConnectFriendServerEvent event) {
        if (!((Boolean)((BetterFriendsConfig)this.addon.configuration()).friendServerSwitchNotifications().get()).booleanValue()) {
            return;
        }
        ServerInfo info = event.serverInfo();
        if (info == null || info.getAddress() == null) {
            return;
        }
        Friend friend = event.friend();
        if (friend == null) {
            return;
        }
        Component address = ((TextComponent)((TextComponent)Component.text((String)info.getAddress()).color(NamedTextColor.AQUA)).clickEvent(ClickEvent.runCommand((String)("/bf join " + info.getDisplayInfo())))).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"betterfriends.notifications.serverUpdate.hover", (TextColor)NamedTextColor.DARK_PURPLE)));
        String gameModeName = info.getGameModeName();
        TranslatableComponent text = gameModeName == null ? Component.translatable((String)"labymod.activity.labyconnect.notifications.server", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{address}) : (TimeUtil.getCurrentTimeMillis() - event.friend().getLastServerChange() < 1000L ? Component.translatable((String)"labymod.activity.labyconnect.notifications.gameModeAndServer", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{Component.text((String)gameModeName, (TextColor)NamedTextColor.AQUA), address}) : Component.translatable((String)"labymod.activity.labyconnect.notifications.gameMode", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{Component.text((String)gameModeName, (TextColor)NamedTextColor.AQUA)}));
        this.addon.displayMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append(GroupHelper.getColoredName(friend))).append((Component)Component.space())).append((Component)text)).color(NamedTextColor.GRAY));
    }
}

