/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.listeners;

import com.rappytv.betterfriends.BetterFriendsAddon;
import com.rappytv.betterfriends.config.BetterFriendsConfig;
import com.rappytv.betterfriends.utils.GroupHelper;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.labymod.labyconnect.session.friend.LabyConnectFriendStatusEvent;
import net.labymod.api.labyconnect.protocol.model.UserStatus;

public class FriendStatusUpdateListener {
    private final BetterFriendsAddon addon;

    public FriendStatusUpdateListener(BetterFriendsAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onStatusUpdate(LabyConnectFriendStatusEvent event) {
        if (!((Boolean)((BetterFriendsConfig)this.addon.configuration()).friendStatusUpdateNotifications().get()).booleanValue()) {
            return;
        }
        UserStatus state = event.getStatus();
        TranslatableComponent stateComponent = Component.translatable((String)state.getLocalTranslationKey(), (TextColor)state.textColor());
        if (state == UserStatus.OFFLINE) {
            stateComponent = Component.translatable((String)"betterfriends.notifications.statusUpdate.offline", (TextColor)NamedTextColor.DARK_GRAY);
        }
        this.addon.displayMessage(((TextComponent)((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)"betterfriends.notifications.statusUpdate.message", (Component[])new Component[]{GroupHelper.getColoredName(event.friend()), stateComponent}))).color(NamedTextColor.GRAY));
    }
}

