/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.listeners;

import com.rappytv.betterfriends.BetterFriendsAddon;
import com.rappytv.betterfriends.config.BetterFriendsConfig;
import com.rappytv.betterfriends.utils.GroupHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.labymod.labyconnect.session.chat.LabyConnectChatMessageEvent;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.labyconnect.protocol.model.User;
import net.labymod.api.labyconnect.protocol.model.chat.TextChatMessage;

public class LabyChatReceiveListener {
    private static final Map<UUID, TextChatMessage> messages = new HashMap<UUID, TextChatMessage>();
    private final BetterFriendsAddon addon;

    public LabyChatReceiveListener(BetterFriendsAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onChatReceive(LabyConnectChatMessageEvent event) {
        if (!((Boolean)((BetterFriendsConfig)this.addon.configuration()).labyChatMessageNotifications().get()).booleanValue()) {
            return;
        }
        TextChatMessage message = (TextChatMessage)event.message();
        LabyConnectSession session = event.labyConnect().getSession();
        if (session == null) {
            return;
        }
        User self = session.self();
        User sender = message.sender();
        User receiver = self.getName().equals(sender.getName()) ? (User)event.chat().getParticipants().getFirst() : self;
        UUID uuid = UUID.randomUUID();
        messages.put(uuid, message);
        if (sender.getName().equals(self.getName()) && !((Boolean)((BetterFriendsConfig)this.addon.configuration()).ownLabyChatMessages().get()).booleanValue()) {
            return;
        }
        Component component = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append(GroupHelper.getColoredName(sender.getName(), sender.gameUser()))).append((Component)Component.text((String)" \u2192 ", (TextColor)NamedTextColor.DARK_GRAY))).append(GroupHelper.getColoredName(receiver.getName(), receiver.gameUser()))).append((Component)Component.text((String)" \u00bb ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)message.getMessage(), (TextColor)NamedTextColor.WHITE));
        int attachments = message.getAttachments().size();
        if (attachments > 0) {
            component.append((Component)Component.space()).append((Component)Component.translatable((String)"betterfriends.notifications.chats.attachments", (TextColor)NamedTextColor.AQUA, (Component[])new Component[]{Component.text((Object)attachments)}));
        }
        if (receiver.getName().equals(Laby.labyAPI().getName()) && ((Boolean)((BetterFriendsConfig)this.addon.configuration()).showInteractionButtons().get()).booleanValue()) {
            component.append(((TextComponent)Component.text((String)" \u2714", (TextColor)NamedTextColor.GREEN).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"betterfriends.notifications.chats.read", (TextColor)NamedTextColor.GREEN)))).clickEvent(ClickEvent.runCommand((String)("/bf read " + String.valueOf(uuid))))).append(((TextComponent)Component.text((String)" \u27a5", (TextColor)NamedTextColor.BLUE).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"betterfriends.notifications.chats.reply", (TextColor)NamedTextColor.BLUE, (Component[])new Component[]{Component.text((String)sender.getName())})))).clickEvent(ClickEvent.suggestCommand((String)("/bf msg " + sender.getName() + " "))));
        }
        this.addon.displayMessage(component);
    }

    public static TextChatMessage getMessage(UUID uuid) {
        return messages.get(uuid);
    }
}

