/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.ui.widgets;

import java.util.List;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.labyconnect.protocol.model.UserStatus;
import net.labymod.api.labyconnect.protocol.model.friend.Friend;

@AutoWidget
public abstract class FriendWidget
extends HorizontalListWidget {
    protected final Friend friend;

    public FriendWidget(Friend friend) {
        this.friend = friend;
    }

    public void initialize(Parent parent) {
        List<ButtonWidget> buttons;
        super.initialize(parent);
        UserStatus userStatus = this.friend.userStatus();
        IconWidget indicatorWidget = new IconWidget(Textures.SpriteCommon.STATUS_INDICATOR);
        indicatorWidget.addId("indicator");
        indicatorWidget.color().set((Object)userStatus.getColor().getValue());
        TranslatableComponent statusComponent = Component.translatable((String)userStatus.getLocalTranslationKey(), (TextColor)userStatus.textColor());
        if (userStatus == UserStatus.OFFLINE) {
            statusComponent = Component.translatable((String)"betterfriends.notifications.statusUpdate.offline", (TextColor)NamedTextColor.DARK_GRAY);
        }
        indicatorWidget.setHoverComponent((Component)statusComponent);
        IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.friend.getUniqueId())).addId("player-head");
        headWidget.setHoverComponent((Component)Component.translatable((String)"betterfriends.general.labynet", (Component[])new Component[0]));
        headWidget.setPressable(() -> Laby.references().chatExecutor().openUrl("https://laby.net/@" + String.valueOf(this.friend.getUniqueId())));
        ComponentWidget usernameWidget = (ComponentWidget)ComponentWidget.component((Component)Component.text((String)this.friend.getName(), (TextColor)TextColor.color((int)this.friend.gameUser().visibleGroup().getColor().getRGB()))).addId("username");
        usernameWidget.setHoverComponent((Component)Component.translatable((String)"betterfriends.general.copyUuid", (Component[])new Component[0]));
        usernameWidget.setPressable(() -> Laby.references().chatExecutor().copyToClipboard(this.friend.getUniqueId().toString()));
        this.addEntry((Widget)indicatorWidget);
        this.addEntry((Widget)headWidget);
        this.addEntry((Widget)usernameWidget);
        if (this.friend.isPinned()) {
            IconWidget pinIconWidget = (IconWidget)new IconWidget(Textures.SpriteCommon.PIN).addId("pin-icon");
            this.addEntry((Widget)pinIconWidget);
        }
        if (!(buttons = this.getButtons()).isEmpty()) {
            HorizontalListWidget buttonWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("buttons");
            for (ButtonWidget button : buttons) {
                buttonWrapper.addEntry((Widget)button);
            }
            this.addEntry((Widget)buttonWrapper);
        }
    }

    public Friend getFriend() {
        return this.friend;
    }

    public int getSortingValue() {
        return 1;
    }

    public abstract List<ButtonWidget> getButtons();
}

