/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.listeners;

import com.rappytv.betterfriends.BetterFriendsAddon;
import com.rappytv.betterfriends.config.BetterFriendsConfig;
import com.rappytv.betterfriends.utils.GroupHelper;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.labymod.labyconnect.session.request.LabyConnectIncomingFriendRequestAddEvent;
import net.labymod.api.labyconnect.protocol.model.request.IncomingFriendRequest;

public class FriendRequestReceiveListener {
    private final BetterFriendsAddon addon;

    public FriendRequestReceiveListener(BetterFriendsAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onFriendRequestReceive(LabyConnectIncomingFriendRequestAddEvent event) {
        if (!((Boolean)((BetterFriendsConfig)this.addon.configuration()).friendRequestNotifications().get()).booleanValue()) {
            return;
        }
        IncomingFriendRequest request = event.request();
        Component sender = GroupHelper.getColoredName(request.getName(), request.gameUser()).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"betterfriends.general.labynet", (TextColor)NamedTextColor.DARK_PURPLE))).clickEvent(ClickEvent.openUrl((String)("https://laby.net/@" + request.getName())));
        switch ((BetterFriendsConfig.FriendRequestReaction)((Object)((BetterFriendsConfig)this.addon.configuration()).automaticFriendRequestReaction().get())) {
            case ACCEPT: {
                request.accept();
                Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)"betterfriends.notifications.friendRequest.automatedAction.accepted", (TextColor)NamedTextColor.GREEN, (Component[])new Component[]{sender})));
                return;
            }
            case DECLINE: {
                request.decline();
                Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)"betterfriends.notifications.friendRequest.automatedAction.declined", (TextColor)NamedTextColor.RED, (Component[])new Component[]{sender})));
                return;
            }
        }
        Laby.references().chatExecutor().displayClientMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)BetterFriendsAddon.getPrefix())).append((Component)Component.translatable((String)"betterfriends.notifications.friendRequest.message", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{sender}))).append((Component)Component.space())).append(((TextComponent)Component.text((String)"\u2714", (TextColor)NamedTextColor.GREEN).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"betterfriends.notifications.friendRequest.hover.accept", (Component[])new Component[0]).color(NamedTextColor.GREEN)))).clickEvent(ClickEvent.runCommand((String)("/bf accept " + request.getName()))))).append((Component)Component.space())).append((Component)Component.text((String)"\u2022", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.space())).append(((TextComponent)Component.text((String)"\u2718", (TextColor)NamedTextColor.RED).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"betterfriends.notifications.friendRequest.hover.decline", (Component[])new Component[0]).color(NamedTextColor.RED)))).clickEvent(ClickEvent.runCommand((String)("/bf decline " + request.getName())))));
    }
}

