/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.listeners;

import com.rappytv.betterfriends.BetterFriendsAddon;
import com.rappytv.betterfriends.config.BetterFriendsConfig;
import com.rappytv.betterfriends.utils.GroupHelper;
import java.util.UUID;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.labymod.labyconnect.session.request.LabyConnectOutgoingFriendRequestRemoveEvent;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.notification.Notification;

public class FriendRequestRemoveListener {
    private final BetterFriendsAddon addon;

    public FriendRequestRemoveListener(BetterFriendsAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onFriendRequestRemove(LabyConnectOutgoingFriendRequestRemoveEvent event) {
        if (!((Boolean)((BetterFriendsConfig)this.addon.configuration()).friendRequestRemovalNotifications().get()).booleanValue()) {
            return;
        }
        LabyConnectSession session = event.labyConnect().getSession();
        if (session == null || !session.isAuthenticated()) {
            return;
        }
        if (session.getFriend(event.request().getUniqueId()) != null) {
            return;
        }
        Notification.builder().title((Component)Component.translatable((String)"betterfriends.notifications.friendRequestRemoval.title", (Component[])new Component[0])).text((Component)Component.translatable((String)"betterfriends.notifications.friendRequestRemoval.description", (Component[])new Component[]{GroupHelper.getColoredName(event.request().getName(), event.request().gameUser())})).icon(Icon.head((UUID)event.request().getUniqueId(), (boolean)true)).duration(15000L).buildAndPush();
    }
}

