/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.ui.hud;

import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.hud.binding.category.HudWidgetCategory;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidget;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextLine;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.labyconnect.LabyConnectSession;

public class FriendCountHudWidget
extends TextHudWidget<TextHudWidgetConfig> {
    private TextLine line;
    private int friendCount;

    public FriendCountHudWidget(HudWidgetCategory category) {
        super("friend_count");
        this.setIcon(Icon.sprite16((ResourceLocation)ResourceLocation.create((String)"labymod", (String)"themes/vanilla/textures/settings/hud/hud.png"), (int)3, (int)0));
        this.bindCategory(category);
    }

    public void load(TextHudWidgetConfig config) {
        super.load(config);
        this.friendCount = 0;
        this.line = super.createLine((Component)Component.translatable((String)"betterfriends.hudWidget.friend_count.key", (Component[])new Component[0]), (Object)this.friendCount);
    }

    public void onTick(boolean isEditorContext) {
        this.line.updateAndFlush((Object)this.friendCount);
    }

    public boolean isVisibleInGame() {
        LabyConnectSession session = Laby.references().labyConnect().getSession();
        if (session == null || !session.isAuthenticated()) {
            return false;
        }
        if (session.getFriends().size() != this.friendCount) {
            this.friendCount = session.getFriends().size();
        }
        return true;
    }
}

