/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.ui.widgets;

import com.rappytv.betterfriends.ui.widgets.FriendWidget;
import java.util.List;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.input.KeyEvent;
import net.labymod.api.labyconnect.protocol.model.friend.Friend;

@AutoWidget
public class FriendlistFriendWidget
extends FriendWidget {
    private static final Component X = Component.text((String)"\u2718", (TextColor)NamedTextColor.RED);
    private boolean skipConfirmation = false;
    private boolean confirmRemoval = false;

    public FriendlistFriendWidget(Friend friend) {
        super(friend);
        Laby.labyAPI().eventBus().registerListener((Object)this);
    }

    @Override
    public List<ButtonWidget> getButtons() {
        if (this.confirmRemoval) {
            ButtonWidget removeConfirmationButton = ButtonWidget.icon((Icon)Textures.SpriteCommon.GREEN_CHECKED, () -> {
                this.friend.remove();
                this.confirmRemoval = false;
                this.reInitialize();
            });
            removeConfirmationButton.setHoverComponent((Component)Component.translatable((String)"betterfriends.settings.advancedFriendlist.removal.confirm", (TextColor)NamedTextColor.GREEN));
            ButtonWidget cancelButton = ButtonWidget.component((Component)X, () -> {
                this.confirmRemoval = false;
                this.reInitialize();
            });
            cancelButton.setHoverComponent((Component)Component.translatable((String)"betterfriends.settings.advancedFriendlist.removal.cancel", (TextColor)NamedTextColor.RED));
            return List.of(removeConfirmationButton, cancelButton);
        }
        ButtonWidget pinButton = (ButtonWidget)ButtonWidget.icon((Icon)Textures.SpriteCommon.PIN, () -> {
            if (this.friend.isPinned()) {
                this.friend.unpin();
            } else {
                this.friend.pin();
            }
            this.reInitialize();
        }).addId("pin-button");
        pinButton.setHoverComponent((Component)Component.translatable((String)(this.friend.isPinned() ? "labymod.activity.labyconnect.chat.action.unpin" : "labymod.activity.labyconnect.chat.action.pin"), (Component[])new Component[0]));
        ButtonWidget noteButton = (ButtonWidget)ButtonWidget.icon((Icon)Textures.SpriteCommon.PAINT, () -> ((Friend)this.friend).openNoteEditor()).addId("note-button");
        noteButton.setHoverComponent((Component)Component.translatable((String)"labymod.activity.labyconnect.chat.action.note", (Component[])new Component[0]));
        ButtonWidget removeButton = (ButtonWidget)ButtonWidget.component((Component)X, () -> {
            if (this.skipConfirmation) {
                this.friend.remove();
            } else {
                this.confirmRemoval = true;
                this.reInitialize();
            }
        }).addId("remove-button");
        removeButton.setHoverComponent(((TranslatableComponent)Component.translatable((String)"betterfriends.settings.advancedFriendlist.removal.label", (TextColor)NamedTextColor.RED).append((Component)Component.newline())).append((Component)Component.translatable((String)"betterfriends.settings.advancedFriendlist.removal.skipConfirmation", (TextColor)NamedTextColor.DARK_GRAY)));
        return List.of(pinButton, noteButton, removeButton);
    }

    @Subscribe
    public void onKeyDown(KeyEvent event) {
        if (event.key() != Key.L_SHIFT) {
            return;
        }
        if (event.state() == KeyEvent.State.PRESS) {
            this.skipConfirmation = true;
        } else if (event.state() == KeyEvent.State.UNPRESSED) {
            this.skipConfirmation = false;
        }
    }

    public void destroy() {
        super.destroy();
        Laby.labyAPI().eventBus().unregisterListener((Object)this);
    }
}

