/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.labymod.api.Constants;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.labyconnect.protocol.model.friend.Friend;
import net.labymod.api.user.GameUser;
import net.labymod.api.user.group.Group;
import net.labymod.api.util.GsonUtil;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.types.GsonRequest;

public class GroupHelper {
    private static final List<Integer> groupIds = new ArrayList<Integer>();

    public static void registerGroupIds() {
        ((GsonRequest)Request.ofGson(JsonElement.class).url(Constants.LegacyUrls.GROUPS, new Object[0])).execute(response -> {
            if (response.hasException()) {
                return;
            }
            JsonElement element = (JsonElement)response.get();
            if (!element.isJsonObject()) {
                return;
            }
            JsonObject groupContainer = element.getAsJsonObject();
            for (JsonElement groupElement : groupContainer.getAsJsonArray("groups")) {
                Group group = (Group)GsonUtil.DEFAULT_GSON.fromJson(groupElement, Group.class);
                group.initialize();
                groupIds.add(group.getIdentifier());
            }
        });
    }

    public static int getGroupIndex(int identifier) {
        int index = groupIds.indexOf(identifier);
        return index != -1 ? index : groupIds.size();
    }

    public static Component getColoredName(Friend friend) {
        return GroupHelper.getColoredName(friend.getName(), friend.gameUser());
    }

    public static Component getColoredName(String name, GameUser user) {
        return Component.text((String)name, (TextColor)user.visibleGroup().getTextColor());
    }
}

