/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.interactions;

import com.rappytv.betterfriends.BetterFriendsAddon;
import com.rappytv.betterfriends.config.BetterFriendsConfig;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.interaction.BulletPoint;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.labyconnect.protocol.model.friend.Friend;

public class FriendTogglePinBullet
implements BulletPoint {
    private final BetterFriendsAddon addon;
    private Friend friend;

    public FriendTogglePinBullet(BetterFriendsAddon addon) {
        this.addon = addon;
    }

    public Component getTitle() {
        return Component.translatable((String)("betterfriends.interactions.togglePin." + (this.friend.isPinned() ? "un" : "") + "pin.title"), (Component[])new Component[0]);
    }

    public Icon getIcon() {
        return Textures.SpriteCommon.PIN;
    }

    public void execute(Player player) {
        if (this.friend.isPinned()) {
            this.friend.unpin();
        } else {
            this.friend.pin();
        }
    }

    public boolean isVisible(Player player) {
        if (!((Boolean)((BetterFriendsConfig)this.addon.configuration()).enabled().get()).booleanValue() || !((Boolean)((BetterFriendsConfig)this.addon.configuration()).togglePinBullet().get()).booleanValue()) {
            return false;
        }
        LabyConnectSession session = Laby.references().labyConnect().getSession();
        if (session == null || !session.isAuthenticated()) {
            return false;
        }
        Friend friend = session.getFriend(player.getUniqueId());
        if (friend == null) {
            return false;
        }
        this.friend = friend;
        return true;
    }
}

