/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.betterfriends.ui.hud;

import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.hud.binding.category.HudWidgetCategory;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidget;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextLine;
import net.labymod.api.labyconnect.LabyConnectSession;

public class UnreadChatCountWidget
extends TextHudWidget<TextHudWidgetConfig> {
    private TextLine line;
    private int unread;

    public UnreadChatCountWidget(HudWidgetCategory category) {
        super("unread_count");
        this.setIcon(Textures.SpriteCommon.CHAT_BUBBLE);
        this.bindCategory(category);
    }

    public void load(TextHudWidgetConfig config) {
        super.load(config);
        this.unread = 0;
        this.line = super.createLine((Component)Component.translatable((String)"betterfriends.hudWidget.unread_count.key", (Component[])new Component[0]), (Object)this.unread);
    }

    public void onTick(boolean isEditorContext) {
        this.line.updateAndFlush((Object)this.unread);
    }

    public boolean isVisibleInGame() {
        LabyConnectSession session = Laby.references().labyConnect().getSession();
        if (session == null || !session.isAuthenticated()) {
            return false;
        }
        if (session.getUnreadCount() != this.unread) {
            this.unread = session.getUnreadCount();
        }
        return this.unread > 0;
    }
}

