/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.betterperspective.core;

import net.labymod.addons.betterperspective.core.BetterPerspectiveConfiguration;
import net.labymod.addons.betterperspective.core.BetterPerspectiveService;
import net.labymod.addons.betterperspective.core.generated.DefaultReferenceStorage;
import net.labymod.addons.betterperspective.core.listener.GameTickListener;
import net.labymod.addons.betterperspective.core.listener.PermissionStateChangeListener;
import net.labymod.addons.betterperspective.core.listener.ServerJoinListener;
import net.labymod.addons.betterperspective.core.misc.BetterPerspectivePerspective;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.chat.ChatExecutor;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.key.HotkeyService;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.user.permission.ClientPermission;

@AddonMain
public class BetterPerspective
extends LabyAddon<BetterPerspectiveConfiguration> {
    public static final String PERMISSION = "better_perspective_unlock_camera";
    private static final Component PREFIX = ((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"BetterPerspective", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY));
    private boolean warningSent;

    protected void enable() {
        this.registerSettingCategory();
        this.registerListener(new GameTickListener(this, this.labyAPI().minecraft()));
        this.registerListener(new PermissionStateChangeListener(this));
        this.registerListener(new ServerJoinListener(this));
        this.labyAPI().permissionRegistry().register(PERMISSION, true);
        Laby.references().hotkeyService().register("betterperspective", ((BetterPerspectiveConfiguration)this.configuration()).key(), () -> (Boolean)((BetterPerspectiveConfiguration)this.configuration()).toggle().get() != false ? HotkeyService.Type.TOGGLE : HotkeyService.Type.HOLD, active -> {
            ClientPermission permission = Laby.labyAPI().permissionRegistry().getPermission(PERMISSION);
            BetterPerspectiveConfiguration configuration = (BetterPerspectiveConfiguration)this.configuration();
            boolean unlockCamera = permission != null && !permission.isEnabled() ? false : (Boolean)configuration.unlockCamera().get();
            BetterPerspectiveService service = this.references().betterPerspectiveService();
            if (active.booleanValue()) {
                service.activate((BetterPerspectivePerspective)((Object)((Object)configuration.thirdPersonMode().get())), (Boolean)configuration.lockPitchRange().get(), unlockCamera);
            } else {
                service.deactivate((Boolean)configuration.resetToPreviousPerspective().get(), unlockCamera);
            }
        });
    }

    protected Class<BetterPerspectiveConfiguration> configurationClass() {
        return BetterPerspectiveConfiguration.class;
    }

    public DefaultReferenceStorage references() {
        return (DefaultReferenceStorage)this.getReferenceStorageAccessor();
    }

    public void displayPermissionWarning() {
        if (this.warningSent) {
            return;
        }
        this.warningSent = true;
        ChatExecutor chatExecutor = this.labyAPI().minecraft().chatExecutor();
        TextComponent component = Component.empty();
        component.append(PREFIX);
        component.append((Component)Component.translatable((String)("betterperspective.permissions." + PERMISSION.replace("_", "-") + ".denied"), (TextColor)NamedTextColor.RED));
        chatExecutor.displayClientMessage((Component)component);
    }

    public void resetWarningSent() {
        this.warningSent = false;
    }
}

