/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.betterperspective.core;

import javax.inject.Inject;
import javax.inject.Singleton;
import net.labymod.addons.betterperspective.core.misc.BetterPerspectivePerspective;
import net.labymod.api.Laby;
import net.labymod.api.LabyAPI;
import net.labymod.api.client.entity.player.CameraLockController;
import net.labymod.api.client.options.MinecraftOptions;
import net.labymod.api.client.options.Perspective;
import net.labymod.api.reference.annotation.Referenceable;

@Singleton
@Referenceable
public class BetterPerspectiveService {
    private final LabyAPI labyAPI = Laby.labyAPI();
    private final CameraLockController cameraLockController = Laby.references().cameraLockController();
    private Perspective previousMode;
    private boolean active = false;

    @Inject
    public BetterPerspectiveService() {
    }

    public void activate(BetterPerspectivePerspective perspective, boolean lockPitchRange, boolean unlockCamera) {
        if (this.active || this.cameraLockController.isLocked()) {
            return;
        }
        this.active = true;
        MinecraftOptions options = this.labyAPI.minecraft().options();
        this.previousMode = options.perspective();
        if (this.previousMode == Perspective.FIRST_PERSON) {
            options.setPerspective(perspective.perspective());
        }
        if (unlockCamera) {
            this.cameraLockController.lock(CameraLockController.LockType.HEAD);
            this.cameraLockController.setUnlimitedPitch(!lockPitchRange);
        }
    }

    public void deactivate(boolean resetPerspective, boolean unlockCamera) {
        if (!this.active) {
            return;
        }
        this.labyAPI.minecraft().options().setPerspective(resetPerspective ? this.previousMode : Perspective.FIRST_PERSON);
        this.active = false;
        if (unlockCamera) {
            this.cameraLockController.unlock();
        }
    }

    public boolean isActive() {
        return this.active;
    }
}

