/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.betterperspective.core.listener;

import net.labymod.addons.betterperspective.core.BetterPerspective;
import net.labymod.addons.betterperspective.core.BetterPerspectiveConfiguration;
import net.labymod.addons.betterperspective.core.BetterPerspectiveService;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.options.Perspective;
import net.labymod.api.event.Phase;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameTickEvent;

public class GameTickListener {
    private final BetterPerspective betterPerspective;
    private final BetterPerspectiveService service;
    private final Minecraft minecraft;

    public GameTickListener(BetterPerspective betterPerspective, Minecraft minecraft) {
        this.betterPerspective = betterPerspective;
        this.service = betterPerspective.references().betterPerspectiveService();
        this.minecraft = minecraft;
    }

    @Subscribe
    public void onGameTick(GameTickEvent event) {
        if (event.phase() != Phase.POST) {
            return;
        }
        ClientPlayer clientPlayer = this.minecraft.clientPlayer();
        if (clientPlayer == null) {
            return;
        }
        if (this.service.isActive() && this.minecraft.options().perspective() == Perspective.FIRST_PERSON) {
            BetterPerspectiveConfiguration configuration = (BetterPerspectiveConfiguration)this.betterPerspective.configuration();
            if (((Boolean)configuration.skipFirstPerson().get()).booleanValue()) {
                this.minecraft.options().setPerspective(Perspective.THIRD_PERSON_BACK);
            } else {
                this.service.deactivate(false, (Boolean)configuration.unlockCamera().get());
            }
        }
    }
}

