/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customblockoverlay.listener;

import java.awt.Color;
import java.util.Objects;
import net.labymod.addons.customblockoverlay.CustomBlockOverlay;
import net.labymod.addons.customblockoverlay.CustomBlockOverlayConfiguration;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.render.world.RenderBlockSelectionBoxEvent;
import net.labymod.api.util.ColorUtil;

public class RenderBlockSelectionBoxListener {
    private final CustomBlockOverlay addon;
    private Color lineColor;
    private Color overlayColor;

    public RenderBlockSelectionBoxListener(CustomBlockOverlay addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onRenderBlockSelectionBox(RenderBlockSelectionBoxEvent event) {
        CustomBlockOverlayConfiguration configuration = (CustomBlockOverlayConfiguration)this.addon.configuration();
        if (!((Boolean)configuration.enabled().get()).booleanValue()) {
            return;
        }
        if (((Boolean)configuration.outlineEnabled().get()).booleanValue()) {
            this.lineColor = this.getCachedOrNewColor(this.lineColor, ((net.labymod.api.util.Color)configuration.outlineColor().get()).get());
            event.setLineColor(this.lineColor);
        } else {
            event.setLineColor(null);
        }
        if (((Boolean)configuration.overlayEnabled().get()).booleanValue()) {
            this.overlayColor = this.getCachedOrNewColor(this.overlayColor, ((net.labymod.api.util.Color)configuration.overlayColor().get()).get());
            event.setOverlayColor(this.overlayColor);
        }
    }

    private Color getCachedOrNewColor(Color color, int rgb) {
        int[] rgba = this.rgbToIntArray(rgb);
        if (Objects.nonNull(color)) {
            boolean matches;
            boolean bl = matches = rgba[0] == color.getRed() && rgba[1] == color.getGreen() && rgba[2] == color.getBlue() && rgba[3] == color.getAlpha();
            if (matches) {
                return color;
            }
        }
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    private int[] rgbToIntArray(int rgb) {
        float[] color = ColorUtil.toRGBA((int)rgb);
        int[] rgba = new int[]{(int)(color[0] * 255.0f), (int)(color[1] * 255.0f), (int)(color[2] * 255.0f), (int)(color[3] * 255.0f)};
        return rgba;
    }
}

