/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.canvas;

import java.util.Base64;
import net.labymod.addons.customcrosshair.misc.Canvas;

public class CrosshairCanvas
extends Canvas<CrosshairCanvas> {
    public static final String ENCODED_PREFIX = "LMCH-";
    public static final String ENCODED_LUNAR_PREFIX = "LCCH-";
    public static final int SIZE = 15;

    public CrosshairCanvas() {
        super(15, 15);
    }

    public static String encode(CrosshairCanvas canvas) {
        int size = CrosshairCanvas.getSize(canvas);
        byte[] bytes = new byte[(int)(Math.ceil((float)(size * size) / 8.0f) + 1.0)];
        bytes[0] = (byte)size;
        int canvasOffset = (int)Math.floor((float)(15 - size) / 2.0f);
        for (int canvasY = 0; canvasY < size; ++canvasY) {
            for (int canvasX = 0; canvasX < size; ++canvasX) {
                int canvasIndex = canvasX + canvasOffset + (canvasY + canvasOffset) * 15;
                if (!canvas.isPixelActive(canvasIndex)) continue;
                int index = canvasX + canvasY * size;
                int n = index / 8 + 1;
                bytes[n] = (byte)(bytes[n] | 1 << index % 8);
            }
        }
        return ENCODED_PREFIX + Base64.getEncoder().encodeToString(bytes);
    }

    public static CrosshairCanvas decode(String encoded) {
        if (!encoded.startsWith(ENCODED_PREFIX)) {
            return CrosshairCanvas.decodeLunarCrosshair(encoded);
        }
        byte[] bytes = Base64.getDecoder().decode(encoded.substring(ENCODED_PREFIX.length()).getBytes());
        return CrosshairCanvas.parseEncoded(bytes[0], bytes, 1);
    }

    public static CrosshairCanvas decodeLunarCrosshair(String encoded) {
        int size;
        if (!encoded.startsWith(ENCODED_LUNAR_PREFIX)) {
            return null;
        }
        String[] split = encoded.trim().split("-");
        if (split.length != 3) {
            return null;
        }
        try {
            size = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(split[2]);
        return CrosshairCanvas.parseEncoded(size, bytes, 0);
    }

    private static CrosshairCanvas parseEncoded(int size, byte[] bytes, int offset) {
        int canvasOffset = (int)Math.floor((float)(15 - size) / 2.0f);
        CrosshairCanvas canvas = new CrosshairCanvas();
        for (int canvasY = 0; canvasY < size; ++canvasY) {
            for (int canvasX = 0; canvasX < size; ++canvasX) {
                int bit;
                int index;
                int canvasIndex = canvasX + canvasOffset + (canvasY + canvasOffset) * 15;
                if (canvasIndex < 0 || canvasIndex >= 225 || (bytes[(index = canvasX + canvasY * size) / 8 + offset] & (bit = 1 << index % 8)) == 0) continue;
                canvas.enablePixel(canvasIndex);
            }
        }
        return canvas;
    }

    private static int getSize(CrosshairCanvas canvas) {
        boolean[] pixels = canvas.getPixels();
        int centerX = canvas.getCenterX();
        int centerY = canvas.getCenterY();
        int minX = centerX;
        int maxX = centerX;
        int minY = centerY;
        int maxY = centerY;
        for (int canvasY = 0; canvasY < 15; ++canvasY) {
            for (int canvasX = 0; canvasX < 15; ++canvasX) {
                if (!pixels[canvasY * 15 + canvasX]) continue;
                if (canvasX < minX) {
                    minX = canvasX;
                }
                if (canvasX > maxX) {
                    maxX = canvasX;
                }
                if (canvasY < minY) {
                    minY = canvasY;
                }
                if (canvasY <= maxY) continue;
                maxY = canvasY;
            }
        }
        int horizontalSize = Math.max(centerX - minX, maxX - centerX);
        int verticalSize = Math.max(centerY - minY, maxY - centerY);
        return Math.max(horizontalSize, verticalSize) * 2 + 1;
    }

    @Override
    public CrosshairCanvas copy() {
        CrosshairCanvas canvas = new CrosshairCanvas();
        this.copyPixelsTo(canvas);
        return canvas;
    }
}

