/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.widgets.settings;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.labymod.addons.customcrosshair.CustomCrosshairConfiguration;
import net.labymod.addons.customcrosshair.activity.CustomCrosshairEditActivity;
import net.labymod.addons.customcrosshair.canvas.CrosshairCanvas;
import net.labymod.addons.customcrosshair.widgets.CrosshairCanvasRendererWidget;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.lss.style.modifier.attribute.AttributeState;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.AbstractWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.configuration.settings.Setting;
import net.labymod.api.configuration.settings.SettingInfo;
import net.labymod.api.configuration.settings.accessor.SettingAccessor;
import net.labymod.api.configuration.settings.annotation.SettingElement;
import net.labymod.api.configuration.settings.annotation.SettingFactory;
import net.labymod.api.configuration.settings.annotation.SettingWidget;
import net.labymod.api.configuration.settings.util.SettingActivitySupplier;
import net.labymod.api.configuration.settings.widget.WidgetFactory;

@SettingWidget
@AutoWidget
@Link(value="crosshair-settings.lss")
public class CustomCrosshairSettingWidget
extends AbstractWidget<Widget>
implements SettingActivitySupplier {
    private final CustomCrosshairConfiguration configuration;
    private final CrosshairCanvasRendererWidget canvasWidget;

    private CustomCrosshairSettingWidget(CustomCrosshairConfiguration configuration, CrosshairCanvas canvas) {
        this.configuration = configuration;
        this.canvasWidget = new CrosshairCanvasRendererWidget(canvas);
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.setAttributeState(AttributeState.ENABLED, true);
        this.addChild((Widget)this.canvasWidget);
    }

    public void update(CrosshairCanvas canvas) {
        this.canvasWidget.update(canvas);
    }

    public Activity activity(Setting setting) {
        return new CustomCrosshairEditActivity(this.configuration);
    }

    @SettingFactory
    public static class Factory
    implements WidgetFactory<CanvasSetting, CustomCrosshairSettingWidget> {
        public CustomCrosshairSettingWidget[] create(Setting setting, CanvasSetting annotation, SettingInfo<?> info, SettingAccessor accessor) {
            if (!(info.config() instanceof CustomCrosshairConfiguration)) {
                throw new IllegalStateException("This setting can only be used within the CustomCrosshair addon");
            }
            CrosshairCanvas canvas = (CrosshairCanvas)accessor.get();
            CustomCrosshairConfiguration configuration = (CustomCrosshairConfiguration)info.config();
            CustomCrosshairSettingWidget canvasWidget = new CustomCrosshairSettingWidget(configuration, canvas);
            configuration.canvas().addChangeListener((property, oldValue, newValue) -> canvasWidget.update((CrosshairCanvas)newValue));
            return new CustomCrosshairSettingWidget[]{canvasWidget};
        }

        public Class<?>[] types() {
            return new Class[]{CrosshairCanvas.class};
        }
    }

    @SettingElement
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CanvasSetting {
    }
}

