/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.listener;

import net.labymod.addons.customcrosshair.CustomCrosshair;
import net.labymod.addons.customcrosshair.CustomCrosshairConfiguration;
import net.labymod.addons.customcrosshair.canvas.CrosshairCanvasIngameRenderer;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.options.Perspective;
import net.labymod.api.event.Phase;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.render.overlay.IngameOverlayElementRenderEvent;
import net.labymod.api.loader.MinecraftVersions;

public class IngameOverlayElementRenderListener {
    private static final boolean V1_8_9_WORKAROUND = MinecraftVersions.V1_8_9.orOlder();
    private final CrosshairCanvasIngameRenderer canvasRenderer;
    private final CustomCrosshair addon;
    private final Minecraft minecraft;

    public IngameOverlayElementRenderListener(CustomCrosshair addon, Minecraft minecraft) {
        this.addon = addon;
        this.minecraft = minecraft;
        this.canvasRenderer = new CrosshairCanvasIngameRenderer(minecraft);
    }

    @Subscribe(value=64)
    public void onRender(IngameOverlayElementRenderEvent event) {
        if (event.phase() != Phase.PRE || this.minecraft.options().isDebugEnabled()) {
            return;
        }
        ScreenContext context = event.screenContext();
        if (V1_8_9_WORKAROUND) {
            if (event.elementType() == IngameOverlayElementRenderEvent.OverlayElementType.CROSSHAIR) {
                event.setCancelled(true);
                this.renderCustomCrosshair(context);
            }
        } else if (event.elementType() == IngameOverlayElementRenderEvent.OverlayElementType.CROSSHAIR) {
            event.setCancelled(true);
        } else if (event.elementType() == IngameOverlayElementRenderEvent.OverlayElementType.BOSS_BAR) {
            this.renderCustomCrosshair(context);
        }
    }

    private void renderCustomCrosshair(ScreenContext context) {
        CustomCrosshairConfiguration configuration = (CustomCrosshairConfiguration)this.addon.configuration();
        Perspective perspective = this.minecraft.options().perspective();
        if (perspective != Perspective.FIRST_PERSON && !((Boolean)configuration.displayInThirdPerson().get()).booleanValue()) {
            return;
        }
        this.canvasRenderer.render(context, configuration);
    }
}

