/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.widgets.edit;

import java.awt.Color;
import net.labymod.addons.customcrosshair.canvas.CrosshairCanvas;
import net.labymod.api.client.gui.lss.property.LssProperty;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.widget.AbstractWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.render.draw.RectangleRenderer;
import net.labymod.api.util.color.format.ColorFormat;

@AutoWidget
public class EditCrosshairCanvasWidget
extends AbstractWidget<Widget> {
    private final RectangleRenderer rectangleRenderer;
    private final CrosshairCanvas canvas;
    private final LssProperty<Integer> canvasBorderColor = new LssProperty((Object)Color.GRAY.getRGB());
    private final LssProperty<Integer> canvasActiveColor = new LssProperty((Object)Color.WHITE.getRGB());
    private float pixelWidth;
    private float pixelHeight;
    private float lastPixelX = -1.0f;
    private float lastPixelY = -1.0f;
    private CrosshairCanvas draggingCanvas;

    public EditCrosshairCanvasWidget(CrosshairCanvas canvas) {
        this.canvas = canvas;
        this.rectangleRenderer = this.labyAPI.renderPipeline().rectangleRenderer();
    }

    public void updateBounds() {
        super.updateBounds();
        Bounds bounds = this.bounds();
        int size = 15;
        this.pixelWidth = (bounds.getWidth() - 15.0f - 1.0f) / 15.0f;
        this.pixelHeight = (bounds.getHeight() - 15.0f - 1.0f) / 15.0f;
    }

    public void renderWidget(ScreenContext context) {
        super.renderWidget(context);
        Bounds bounds = this.bounds();
        float width = bounds.getWidth();
        float height = bounds.getHeight();
        int x = (int)bounds.getX();
        int y = (int)bounds.getY();
        int borderColor = (Integer)this.canvasBorderColor.get();
        ScreenCanvas canvas = context.canvas();
        canvas.submitRelativeRect((float)x, (float)y, width, 1.0f, borderColor);
        canvas.submitRelativeRect((float)x++, (float)y, 1.0f, height - 1.0f, borderColor);
        int size = 15;
        int centerIndex = this.canvas.getCenterX() + 15 * this.canvas.getCenterY();
        int activeColor = (Integer)this.canvasActiveColor.get();
        boolean[] pixels = this.canvas.getPixels();
        for (int canvasY = 0; canvasY < 15; ++canvasY) {
            for (int canvasX = 0; canvasX < 15; ++canvasX) {
                float pixelX = (float)x + (float)canvasX * this.pixelWidth;
                float pixelY = (float)y + (float)canvasY * this.pixelHeight;
                int index = canvasX + 15 * canvasY;
                if (index == centerIndex) {
                    canvas.submitRelativeRect(pixelX, pixelY, this.pixelWidth, this.pixelHeight, ColorFormat.ARGB32.pack(0.098f, 0.098f, 0.098f, 0.1f));
                }
                if (pixels[index]) {
                    canvas.submitRelativeRect(pixelX, pixelY, this.pixelWidth, this.pixelHeight, activeColor);
                }
                canvas.submitRelativeRect(pixelX + this.pixelWidth, pixelY, 1.0f, this.pixelHeight + 1.0f, borderColor);
                canvas.submitRelativeRect(pixelX, pixelY + this.pixelHeight, this.pixelWidth, 1.0f, borderColor);
                if (canvasX == 14) {
                    x = (int)bounds.getX() + 1;
                    ++y;
                    continue;
                }
                ++x;
            }
        }
    }

    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        Boolean active;
        if (mouseButton == MouseButton.LEFT) {
            active = true;
        } else if (mouseButton == MouseButton.RIGHT) {
            active = false;
        } else if (mouseButton == MouseButton.MIDDLE) {
            active = null;
        } else {
            return false;
        }
        this.draggingCanvas = this.canvas.copy();
        return this.setPixel(mouse.getX(), mouse.getY(), active);
    }

    public boolean mouseDragged(MutableMouse mouse, MouseButton mouseButton, double deltaX, double deltaY) {
        Boolean active;
        if (mouseButton == MouseButton.LEFT) {
            active = true;
        } else if (mouseButton == MouseButton.RIGHT) {
            active = false;
        } else if (mouseButton == MouseButton.MIDDLE) {
            active = null;
        } else {
            return false;
        }
        return this.setPixel(mouse.getX(), mouse.getY(), active);
    }

    public boolean mouseReleased(MutableMouse mouse, MouseButton mouseButton) {
        this.lastPixelX = -1.0f;
        this.lastPixelY = -1.0f;
        this.draggingCanvas = null;
        return super.mouseReleased(mouse, mouseButton);
    }

    public LssProperty<Integer> canvasBorderColor() {
        return this.canvasBorderColor;
    }

    public LssProperty<Integer> canvasActiveColor() {
        return this.canvasActiveColor;
    }

    public void update(CrosshairCanvas canvas) {
        canvas.copyPixelsTo(this.canvas);
    }

    public CrosshairCanvas canvas() {
        return this.canvas;
    }

    private boolean setPixel(int mouseX, int mouseY, Boolean active) {
        Bounds bounds = this.bounds();
        int x = (int)bounds.getX();
        int y = (int)bounds.getY();
        int size = 15;
        int absoluteMouseX = mouseX - x;
        int absoluteMouseY = mouseY - y;
        int canvasX = (int)((float)(absoluteMouseX - (int)((float)absoluteMouseX / this.pixelWidth) - 1) / this.pixelWidth);
        int canvasY = (int)((float)(absoluteMouseY - (int)((float)absoluteMouseY / this.pixelHeight) - 1) / this.pixelHeight);
        if (canvasX < 0 || canvasX >= 15 || canvasY < 0 || canvasY >= 15) {
            return false;
        }
        if (this.lastPixelX == (float)canvasX && this.lastPixelY == (float)canvasY) {
            return false;
        }
        if (active == null) {
            if (this.draggingCanvas == null) {
                this.canvas.togglePixel(canvasX, canvasY);
            } else {
                boolean pixelActive = this.draggingCanvas.isPixelActive(canvasX, canvasY);
                if (pixelActive) {
                    this.canvas.disablePixel(canvasX, canvasY);
                } else {
                    this.canvas.enablePixel(canvasX, canvasY);
                }
            }
        } else if (active.booleanValue() && (this.draggingCanvas == null || !this.draggingCanvas.isPixelActive(canvasX, canvasY))) {
            this.canvas.enablePixel(canvasX, canvasY);
        } else if (!active.booleanValue() && (this.draggingCanvas == null || this.draggingCanvas.isPixelActive(canvasX, canvasY))) {
            this.canvas.disablePixel(canvasX, canvasY);
        }
        this.lastPixelX = canvasX;
        this.lastPixelY = canvasY;
        return true;
    }

    public CrosshairCanvas saveDraft() {
        return this.canvas;
    }
}

