/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.canvas;

import net.labymod.addons.customcrosshair.CustomCrosshairPrograms;
import net.labymod.addons.customcrosshair.canvas.CrosshairCanvas;
import net.labymod.api.Textures;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.state.states.GuiTextureSet;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.util.Color;

public class CrosshairCanvasRenderer {
    private static final int DEFAULT_COLOR = Color.WHITE.get();

    public void renderVanillaBlended(ScreenCanvas screenCanvas, CrosshairCanvas crosshairCanvas, float minX, float minY) {
        this.renderVanillaBlended(screenCanvas, crosshairCanvas, minX, minY, DEFAULT_COLOR);
    }

    public void renderVanillaBlended(ScreenCanvas screenCanvas, CrosshairCanvas crosshairCanvas, float minX, float minY, int color) {
        this.render(screenCanvas, crosshairCanvas, minX, minY, color);
    }

    private void render(ScreenCanvas screenCanvas, CrosshairCanvas crosshairCanvas, float minX, float minY, int color) {
        GuiTextureSet textureSet = GuiTextureSet.single((ResourceLocation)Textures.WHITE);
        boolean[] pixels = crosshairCanvas.getPixels();
        for (int x = 0; x < 15; ++x) {
            for (int y = 0; y < 15; ++y) {
                if (!pixels[x + 15 * y]) continue;
                screenCanvas.submitGuiBlit(CustomCrosshairPrograms.VANILLA_BLENDED, textureSet, minX + (float)x, minY + (float)y, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, color);
            }
        }
    }

    public void renderColored(ScreenCanvas screenCanvas, CrosshairCanvas canvas, float minX, float minY) {
        this.renderColored(screenCanvas, canvas, minX, minY, DEFAULT_COLOR);
    }

    public void renderColored(ScreenCanvas screenCanvas, CrosshairCanvas canvas, float minX, float minY, int color) {
        boolean[] pixels = canvas.getPixels();
        for (int x = 0; x < 15; ++x) {
            for (int y = 0; y < 15; ++y) {
                if (!pixels[x + 15 * y]) continue;
                screenCanvas.submitRelativeRect(minX + (float)x, minY + (float)y, 1.0f, 1.0f, color);
            }
        }
    }
}

