/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.canvas;

import net.labymod.addons.customcrosshair.CustomCrosshairConfiguration;
import net.labymod.addons.customcrosshair.canvas.CrosshairCanvas;
import net.labymod.addons.customcrosshair.canvas.CrosshairCanvasRenderer;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.entity.Entity;
import net.labymod.api.client.entity.LivingEntity;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.util.Color;

public class CrosshairCanvasIngameRenderer
extends CrosshairCanvasRenderer {
    private final Minecraft minecraft;

    public CrosshairCanvasIngameRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void render(ScreenContext context, CustomCrosshairConfiguration configuration) {
        Bounds bounds = this.minecraft.minecraftWindow().bounds();
        float x = (int)((bounds.getWidth() - 15.0f) / 2.0f);
        float y = (int)((bounds.getHeight() - 15.0f) / 2.0f);
        Stack stack = context.stack();
        stack.push();
        int degrees = (Integer)configuration.rotation().get();
        if (degrees != 0 && degrees != 360) {
            float translationX = x + 7.5f;
            float translationY = y + 7.5f;
            stack.translate(translationX, translationY, 0.0f);
            stack.rotate((float)degrees, 0.0f, 0.0f, 1.0f);
            stack.translate(translationX * -1.0f, translationY * -1.0f, 0.0f);
        }
        ScreenCanvas canvas = context.canvas();
        canvas.down();
        this.renderCanvas(context, configuration, x, y);
        canvas.up();
        stack.pop();
    }

    private void renderCanvas(ScreenContext context, CustomCrosshairConfiguration configuration, float minX, float minY) {
        CrosshairCanvas canvas = (CrosshairCanvas)configuration.canvas().get();
        if (canvas == null) {
            return;
        }
        if (((Boolean)configuration.vanillaBlending().get()).booleanValue()) {
            this.renderVanillaBlended(context.canvas(), canvas, minX, minY);
            return;
        }
        this.renderColored(context.canvas(), canvas, minX, minY, this.getColor(configuration));
    }

    private int getColor(CustomCrosshairConfiguration configuration) {
        Entity targetEntity = this.minecraft.getTargetEntity();
        if (!((Boolean)configuration.dynamicColor().get()).booleanValue() || !(targetEntity instanceof LivingEntity)) {
            return ((Color)configuration.color().get()).get();
        }
        if (targetEntity instanceof Player) {
            return ((Color)configuration.playerColor().get()).get();
        }
        return ((LivingEntity)targetEntity).isHostile() ? ((Color)configuration.hostileColor().get()).get() : ((Color)configuration.neutralColor().get()).get();
    }
}

