/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.misc;

import java.util.Arrays;
import java.util.Objects;

public abstract class Canvas<T extends Canvas<T>> {
    private static final String X_OUT_OF_BOUNDS = "x is %s but must be smaller than %s";
    private static final String Y_OUT_OF_BOUNDS = "y is %s but must be smaller than %s";
    private final boolean[] pixels;
    private final int width;
    private final int height;
    private final int centerX;
    private final int centerY;
    private final int totalSize;

    protected Canvas(int width, int height) {
        this.width = width;
        this.height = height;
        this.totalSize = width * height;
        this.pixels = new boolean[this.totalSize];
        this.centerX = (int)Math.floor((double)width / 2.0);
        this.centerY = (int)Math.floor((double)height / 2.0);
    }

    public T enablePixel(int pixel) {
        this.checkTotalRange(pixel);
        this.pixels[pixel] = true;
        return (T)this;
    }

    public T disablePixel(int pixel) {
        this.checkTotalRange(pixel);
        this.pixels[pixel] = false;
        return (T)this;
    }

    public T togglePixel(int pixel) {
        if (this.isPixelActive(pixel)) {
            this.disablePixel(pixel);
        } else {
            this.enablePixel(pixel);
        }
        return (T)this;
    }

    public T togglePixel(int x, int y) {
        this.checkRange(x, X_OUT_OF_BOUNDS, this.width);
        this.checkRange(y, Y_OUT_OF_BOUNDS, this.height);
        return this.togglePixel(x + this.height * y);
    }

    public T enablePixel(int x, int y) {
        this.checkRange(x, X_OUT_OF_BOUNDS, this.width);
        this.checkRange(y, Y_OUT_OF_BOUNDS, this.height);
        return this.enablePixel(x + this.height * y);
    }

    public T enableFromCenter(int x, int y) {
        int xFromCenter = this.centerX + x;
        int yFromCenter = this.centerY + y;
        this.checkRange(xFromCenter, X_OUT_OF_BOUNDS, this.width);
        this.checkRange(yFromCenter, Y_OUT_OF_BOUNDS, this.height);
        return this.enablePixel(xFromCenter, yFromCenter);
    }

    public T disablePixel(int x, int y) {
        this.checkRange(x, X_OUT_OF_BOUNDS, this.width);
        this.checkRange(y, Y_OUT_OF_BOUNDS, this.height);
        return this.disablePixel(x + this.height * y);
    }

    public T disableFromCenter(int x, int y) {
        int xFromCenter = this.centerX + x;
        int yFromCenter = this.centerY + y;
        this.checkRange(xFromCenter, X_OUT_OF_BOUNDS, this.width);
        this.checkRange(yFromCenter, Y_OUT_OF_BOUNDS, this.height);
        return this.disablePixel(xFromCenter, yFromCenter);
    }

    public boolean isPixelActive(int pixel) {
        this.checkTotalRange(pixel);
        return this.pixels[pixel];
    }

    public boolean isPixelActive(int x, int y) {
        this.checkRange(x, X_OUT_OF_BOUNDS, this.width);
        this.checkRange(y, Y_OUT_OF_BOUNDS, this.height);
        return this.isPixelActive(x + this.height * y);
    }

    public boolean[] getPixels() {
        return this.pixels;
    }

    public abstract T copy();

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void checkRange(int value, String message, int maxValue) {
        if (value < 0 || value >= maxValue) {
            throw new IllegalArgumentException(String.format(message, value, maxValue));
        }
    }

    protected void checkTotalRange(int value) {
        if (value < 0 || value >= this.totalSize) {
            throw new IllegalArgumentException("Pixel " + value + " is out of bounds (min: 0, max: " + this.totalSize + ")");
        }
    }

    public void copyPixelsTo(Canvas<?> canvas) {
        System.arraycopy(this.pixels, 0, canvas.pixels, 0, this.pixels.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Canvas)) {
            return false;
        }
        Canvas canvas = (Canvas)o;
        return this.width == canvas.width && this.height == canvas.height && Arrays.equals(this.pixels, canvas.pixels);
    }

    public int hashCode() {
        int result = Objects.hash(this.width, this.height);
        result = 31 * result + Arrays.hashCode(this.pixels);
        return result;
    }
}

