/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.widgets.edit;

import net.labymod.addons.customcrosshair.widgets.CrosshairCanvasRendererWidget;
import net.labymod.api.client.gui.lss.property.LssProperty;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.AutoAlignType;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.BoundsType;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.ListWidget;
import net.labymod.api.util.bounds.ModifyReason;
import net.labymod.api.util.bounds.ReasonableMutableRectangle;
import net.labymod.api.util.bounds.Rectangle;

@AutoWidget
public class CrosshairPresetListWidget
extends ListWidget<CrosshairCanvasRendererWidget> {
    private static final ModifyReason MODIFY_REASON = ModifyReason.of((String)"CrosshairPresetListWidget");
    private final LssProperty<Float> spaceBetweenEntries = new LssProperty((Object)Float.valueOf(0.0f));

    public void onBoundsChanged(Rectangle previousRect, Rectangle newRect) {
        super.onBoundsChanged(previousRect, newRect);
        this.updateChildren();
    }

    protected void updateChildren() {
        Bounds bounds = this.bounds();
        float maxX = bounds.getMaxX();
        float startX = bounds.getX();
        float startY = bounds.getY();
        float x = startX;
        float y = startY;
        float rowHeight = 0.0f;
        for (CrosshairCanvasRendererWidget child : this.children) {
            ReasonableMutableRectangle childBounds = child.bounds().rectangle(BoundsType.OUTER);
            float childWidth = childBounds.getWidth();
            if (x + childWidth > maxX) {
                x = startX;
                y += rowHeight + ((Float)this.spaceBetweenEntries.get()).floatValue();
            }
            childBounds.setPosition(x, y, MODIFY_REASON);
            rowHeight = Math.max(childBounds.getHeight(), rowHeight);
            x += childWidth + ((Float)this.spaceBetweenEntries.get()).floatValue();
        }
        bounds.setHeight(y - startY + rowHeight, MODIFY_REASON);
    }

    public LssProperty<Float> spaceBetweenEntries() {
        return this.spaceBetweenEntries;
    }

    public boolean hasAutoBounds(Widget child, AutoAlignType type) {
        return type == AutoAlignType.POSITION;
    }
}

