/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customcrosshair.activity;

import java.util.concurrent.TimeUnit;
import net.labymod.addons.customcrosshair.CustomCrosshairConfiguration;
import net.labymod.addons.customcrosshair.canvas.CrosshairCanvas;
import net.labymod.addons.customcrosshair.canvas.CrosshairCanvasPreset;
import net.labymod.addons.customcrosshair.widgets.CrosshairCanvasRendererWidget;
import net.labymod.addons.customcrosshair.widgets.edit.CrosshairPresetListWidget;
import net.labymod.addons.customcrosshair.widgets.edit.EditCrosshairCanvasWidget;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.lss.style.modifier.attribute.AttributeState;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.notification.Notification;
import net.labymod.api.util.concurrent.task.Task;

@Link(value="edit.lss")
public class CustomCrosshairEditActivity
extends Activity {
    private final CustomCrosshairConfiguration configuration;
    private EditCrosshairCanvasWidget editCanvas;
    private ButtonWidget importButton;
    private Task clipboardRefreshTask;

    public CustomCrosshairEditActivity(CustomCrosshairConfiguration configuration) {
        this.configuration = configuration;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        VerticalListWidget container = new VerticalListWidget();
        container.addId("container");
        ComponentWidget presetTitle = ComponentWidget.i18n((String)"customcrosshair.activity.presets.title");
        presetTitle.addId("title");
        container.addChild((Widget)presetTitle);
        CrosshairPresetListWidget presetContainer = new CrosshairPresetListWidget();
        presetContainer.addId("preset-container");
        for (CrosshairCanvasPreset preset : CrosshairCanvasPreset.getValues()) {
            CrosshairCanvas canvas = preset.getCanvas();
            CrosshairCanvasRendererWidget widget = new CrosshairCanvasRendererWidget(canvas);
            widget.setPressable(() -> this.editCanvas.update(canvas));
            widget.setAttributeState(AttributeState.ENABLED, true);
            presetContainer.addChild((Widget)widget);
        }
        container.addChild((Widget)presetContainer);
        ComponentWidget editTitle = ComponentWidget.i18n((String)"customcrosshair.activity.edit.title");
        editTitle.addId("title");
        container.addChild((Widget)editTitle);
        FlexibleContentWidget editWrapper = new FlexibleContentWidget();
        editWrapper.addId("edit-wrapper");
        this.editCanvas = new EditCrosshairCanvasWidget((CrosshairCanvas)this.configuration.canvas().get());
        this.editCanvas.addId("edit-canvas");
        editWrapper.addContent((Widget)this.editCanvas);
        FlexibleContentWidget inputWrapper = new FlexibleContentWidget();
        inputWrapper.addId("input-wrapper");
        ButtonWidget shareButton = ButtonWidget.i18n((String)"customcrosshair.activity.edit.share.name");
        shareButton.addId("share-button");
        shareButton.setHoverComponent((Component)Component.translatable((String)"customcrosshair.activity.edit.share.description", (Component[])new Component[0]));
        shareButton.setPressable(() -> {
            try {
                String encode = CrosshairCanvas.encode(this.editCanvas.canvas());
                this.labyAPI.minecraft().setClipboard(encode);
                this.pushNotification("customcrosshair.notification.share.copied");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.pushNotification("customcrosshair.notification.share.error");
            }
        });
        inputWrapper.addContent((Widget)shareButton);
        this.importButton = ButtonWidget.i18n((String)"customcrosshair.activity.edit.import.name");
        this.importButton.addId("import-button");
        this.importButton.setHoverComponent((Component)Component.translatable((String)"customcrosshair.activity.edit.import.description", (Component[])new Component[0]));
        this.importButton.setEnabled(this.isClipboardValid());
        this.importButton.setPressable(() -> {
            if (!this.importButton.isAttributeStateEnabled(AttributeState.ENABLED)) {
                return;
            }
            String clipboard = this.labyAPI.minecraft().getClipboard();
            if (!this.isValid(clipboard)) {
                this.importButton.setEnabled(false);
                this.pushNotification("customcrosshair.notification.import.invalid");
                return;
            }
            CrosshairCanvas canvas = CrosshairCanvas.decode(clipboard);
            if (canvas == null) {
                this.importButton.setEnabled(false);
                this.pushNotification("customcrosshair.notification.import.error");
                return;
            }
            this.pushNotification("customcrosshair.notification.import.success");
            this.editCanvas.update(canvas);
        });
        inputWrapper.addContent((Widget)this.importButton);
        editWrapper.addFlexibleContent((Widget)inputWrapper);
        container.addChild((Widget)editWrapper);
        ((Document)this.document).addChild((Widget)new ScrollWidget(container));
    }

    public void onCloseScreen() {
        if (this.clipboardRefreshTask != null) {
            this.clipboardRefreshTask.cancel();
            this.clipboardRefreshTask = null;
        }
        this.configuration.canvas().set((Object)this.editCanvas.saveDraft());
        super.onCloseScreen();
    }

    public void onOpenScreen() {
        super.onOpenScreen();
        if (this.clipboardRefreshTask != null) {
            this.clipboardRefreshTask.cancel();
        }
        this.clipboardRefreshTask = Task.builder(() -> {
            if (this.importButton == null) {
                return;
            }
            this.importButton.setEnabled(this.isClipboardValid());
        }).repeat(1L, TimeUnit.SECONDS).build();
        this.clipboardRefreshTask.executeOnRenderThread();
    }

    private boolean isValid(String clipboard) {
        return clipboard != null && (clipboard.startsWith("LMCH-") || clipboard.startsWith("LCCH-"));
    }

    private boolean isClipboardValid() {
        return this.isValid(this.labyAPI.minecraft().getClipboard());
    }

    private void pushNotification(String translationKey) {
        Notification notification = Notification.builder().title((Component)Component.translatable((String)"customcrosshair.settings.name", (Component[])new Component[0])).text((Component)Component.translatable((String)translationKey, (Component[])new Component[0])).build();
        this.labyAPI.notificationController().push(notification);
    }
}

