/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags.gui.activity;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.labymod.addons.customnametags.CustomNameTag;
import net.labymod.addons.customnametags.CustomNameTags;
import net.labymod.addons.customnametags.CustomNameTagsConfiguration;
import net.labymod.addons.customnametags.gui.activity.NameTagWidget;
import net.labymod.addons.customnametags.gui.popup.EditNameTagPopup;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.Links;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.popup.SimpleAdvancedPopup;
import net.labymod.api.client.render.font.TextColorStripper;
import net.labymod.api.event.Event;
import net.labymod.api.event.client.gui.screen.playerlist.PlayerListUpdateEvent;
import org.jetbrains.annotations.NotNull;

@AutoActivity
@Links(value={@Link(value="manage.lss"), @Link(value="overview.lss")})
public class NameTagActivity
extends Activity {
    private static final Pattern NAME_PATTERN = Pattern.compile("\\w{0,16}");
    private static final TextColorStripper TEXT_COLOR_STRIPPER = Laby.references().textColorStripper();
    private final CustomNameTags addon = CustomNameTags.get();
    private final VerticalListWidget<NameTagWidget> nameTagList;
    private final Map<String, NameTagWidget> nameTagWidgets = new HashMap<String, NameTagWidget>();
    private CustomNameTag selectedNameTag;
    private ButtonWidget removeButton;
    private ButtonWidget editButton;
    private FlexibleContentWidget inputWidget;
    private String lastUserName;
    private String lastCustomName;
    private Action action;
    private boolean updateRequired;

    public NameTagActivity() {
        this.loadNameTags();
        this.nameTagList = new VerticalListWidget();
        this.nameTagList.addId("name-tag-list");
        this.nameTagList.setSelectCallback(nameTagWidget -> {
            NameTagWidget selectedNameTag = (NameTagWidget)((Object)((Object)this.nameTagList.session().getSelectedEntry()));
            if (selectedNameTag == null || selectedNameTag.getCustomTag() != nameTagWidget.getCustomTag()) {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        });
        this.nameTagList.setDoubleClickCallback(nameTagWidget -> this.performAction(Action.EDIT));
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = new FlexibleContentWidget();
        container.addId("name-tag-container");
        for (NameTagWidget nameTagWidget : this.nameTagWidgets.values()) {
            this.nameTagList.addChild((Widget)nameTagWidget);
        }
        container.addFlexibleContent((Widget)new ScrollWidget(this.nameTagList));
        NameTagWidget selectedEntry = (NameTagWidget)((Object)this.nameTagList.session().getSelectedEntry());
        this.selectedNameTag = selectedEntry != null ? selectedEntry.getCustomTag() : null;
        HorizontalListWidget menu = new HorizontalListWidget();
        menu.addId("overview-button-menu");
        menu.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.add", () -> this.performAction(Action.ADD)));
        this.editButton = ButtonWidget.i18n((String)"labymod.ui.button.edit", () -> this.performAction(Action.EDIT));
        this.editButton.setEnabled(this.selectedNameTag != null);
        menu.addEntry((Widget)this.editButton);
        this.removeButton = ButtonWidget.i18n((String)"labymod.ui.button.remove", () -> this.performAction(Action.REMOVE));
        this.removeButton.setEnabled(this.selectedNameTag != null);
        menu.addEntry((Widget)this.removeButton);
        container.addContent((Widget)menu);
        ((Document)this.document()).addChild((Widget)container);
    }

    private String getStrippedText(String text) {
        if ((text = text.trim()).isEmpty()) {
            return text;
        }
        return TEXT_COLOR_STRIPPER.stripColorCodes(text, '&');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        block3: {
            boolean bl;
            try {
                if (this.action == null) break block3;
                bl = this.inputWidget.mouseClicked(mouse, mouseButton);
            }
            catch (Throwable throwable) {
                NameTagWidget selectedEntry = (NameTagWidget)((Object)this.nameTagList.session().getSelectedEntry());
                this.selectedNameTag = selectedEntry != null ? selectedEntry.getCustomTag() : null;
                this.removeButton.setEnabled(this.selectedNameTag != null);
                this.editButton.setEnabled(this.selectedNameTag != null);
                throw throwable;
            }
            NameTagWidget selectedEntry = (NameTagWidget)((Object)this.nameTagList.session().getSelectedEntry());
            this.selectedNameTag = selectedEntry != null ? selectedEntry.getCustomTag() : null;
            this.removeButton.setEnabled(this.selectedNameTag != null);
            this.editButton.setEnabled(this.selectedNameTag != null);
            return bl;
        }
        boolean bl = super.mouseClicked(mouse, mouseButton);
        NameTagWidget selectedEntry = (NameTagWidget)((Object)this.nameTagList.session().getSelectedEntry());
        this.selectedNameTag = selectedEntry != null ? selectedEntry.getCustomTag() : null;
        this.removeButton.setEnabled(this.selectedNameTag != null);
        this.editButton.setEnabled(this.selectedNameTag != null);
        return bl;
    }

    public void reload() {
        this.loadNameTags();
        super.reload();
    }

    private void loadNameTags() {
        this.nameTagWidgets.clear();
        ((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().forEach((userName, customTag) -> this.nameTagWidgets.put((String)userName, new NameTagWidget((CustomNameTag)customTag)));
    }

    private void performAction(@NotNull Action action) {
        switch (action.ordinal()) {
            case 0: {
                new EditNameTagPopup(CustomNameTag.ofDefault(), (CustomNameTagsConfiguration)this.addon.configuration(), customNameTag -> {
                    this.selectedNameTag = customNameTag;
                    this.reload();
                });
                break;
            }
            case 1: {
                new EditNameTagPopup(((NameTagWidget)((Object)this.nameTagList.listSession().getSelectedEntry())).getCustomTag(), (CustomNameTagsConfiguration)this.addon.configuration(), ignored -> this.reload());
                break;
            }
            case 2: {
                SimpleAdvancedPopup.builder().title((Component)Component.translatable((String)"customnametags.gui.manage.remove.title", (Component[])new Component[0])).description((Component)Component.translatable((String)"customnametags.gui.manage.remove.description", (Component[])new Component[0]).argument((Component)Component.text((String)this.selectedNameTag.getOriginalName()))).addButton(SimpleAdvancedPopup.SimplePopupButton.confirm(simplePopupButton -> {
                    ((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().remove(this.selectedNameTag.getOriginalName());
                    this.reload();
                    Laby.fireEvent((Event)new PlayerListUpdateEvent());
                })).addButton(SimpleAdvancedPopup.SimplePopupButton.cancel()).build().displayInOverlay();
            }
        }
    }

    public void onCloseScreen() {
        super.onCloseScreen();
        if (this.updateRequired) {
            this.addon.reloadTabList();
        }
    }

    private static enum Action {
        ADD,
        EDIT,
        REMOVE;

    }
}

