/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags.gui.activity;

import net.labymod.addons.customnametags.CustomNameTag;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@AutoWidget
public class NameTagWidget
extends SimpleWidget {
    private String userName;
    private CustomNameTag customNameTag;

    public NameTagWidget(String userName, CustomNameTag customNameTag) {
        this.userName = userName;
        this.customNameTag = customNameTag;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        if (this.customNameTag.isEnabled()) {
            this.removeId("disabled");
        } else {
            this.addId("disabled");
        }
        IconWidget iconWidget = new IconWidget(this.getIconWidget(this.userName));
        iconWidget.addId("avatar");
        this.addChild((Widget)iconWidget);
        ComponentWidget nameWidget = ComponentWidget.component((Component)Component.text((String)this.userName));
        nameWidget.addId("name");
        this.addChild((Widget)nameWidget);
        ComponentWidget customNameWidget = ComponentWidget.component((Component)this.customNameTag.displayName());
        customNameWidget.addId("custom-name");
        this.addChild((Widget)customNameWidget);
    }

    public Icon getIconWidget(String userName) {
        return Icon.head((String)(userName.length() == 0 ? "MHF_Question" : userName));
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public CustomNameTag getCustomTag() {
        return this.customNameTag;
    }

    public void setCustomTag(CustomNameTag customNameTag) {
        this.customNameTag = customNameTag;
    }
}

