/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags.listener;

import java.util.Map;
import java.util.Set;
import net.labymod.addons.customnametags.CustomNameTag;
import net.labymod.addons.customnametags.CustomNameTags;
import net.labymod.addons.customnametags.CustomNameTagsConfiguration;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.network.NetworkPlayerInfo;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.render.PlayerNameTagRenderEvent;
import net.labymod.api.util.Pair;

public class PlayerNameTagRenderListener {
    private final CustomNameTags addon;

    public PlayerNameTagRenderListener(CustomNameTags addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onPlayerNameTagRender(PlayerNameTagRenderEvent event) {
        CustomNameTag customNameTag;
        String playerName;
        NetworkPlayerInfo networkPlayerInfo = event.playerInfo();
        if (networkPlayerInfo == null) {
            return;
        }
        if (event.context() == PlayerNameTagRenderEvent.Context.TAB_LIST && ((Boolean)((CustomNameTagsConfiguration)this.addon.configuration()).checkForStringInTabList().get()).booleanValue()) {
            Pair<String, CustomNameTag> pair = this.getCustomNameTag(((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().entrySet(), event.nameTag());
            if (pair == null) {
                playerName = null;
                customNameTag = null;
            } else {
                playerName = (String)pair.getFirst();
                customNameTag = (CustomNameTag)pair.getSecond();
            }
        } else {
            playerName = networkPlayerInfo.profile().getUsername();
            customNameTag = this.getCustomNameTag(playerName);
        }
        if (customNameTag == null || !customNameTag.isEnabled()) {
            return;
        }
        if (customNameTag.isReplaceScoreboard()) {
            event.setNameTag(customNameTag.displayName().copy());
        } else {
            Component newNameTag = event.nameTag().copy();
            this.addon.replaceUsername(newNameTag, playerName, () -> customNameTag.displayName().copy());
            event.setNameTag(newNameTag);
        }
    }

    private CustomNameTag getCustomNameTag(String playerName) {
        for (Map.Entry<String, CustomNameTag> customTagEntry : ((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().entrySet()) {
            CustomNameTag customNameTag = customTagEntry.getValue();
            if (!customTagEntry.getKey().equalsIgnoreCase(playerName)) continue;
            return customNameTag;
        }
        return null;
    }

    private Pair<String, CustomNameTag> getCustomNameTag(Set<Map.Entry<String, CustomNameTag>> customNameTags, Component component) {
        for (Component child : component.getChildren()) {
            Pair<String, CustomNameTag> pair = this.getCustomNameTag(customNameTags, child);
            if (pair == null) continue;
            return pair;
        }
        if (!(component instanceof TextComponent)) {
            return null;
        }
        TextComponent textComponent = (TextComponent)component;
        String text = textComponent.getText().toLowerCase();
        for (Map.Entry<String, CustomNameTag> customNameTag : customNameTags) {
            if (!text.endsWith(customNameTag.getKey().toLowerCase())) continue;
            return Pair.of((Object)customNameTag.getKey(), (Object)customNameTag.getValue());
        }
        return null;
    }
}

