/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags;

import java.util.function.Supplier;
import net.labymod.addons.customnametags.CustomNameTagsConfiguration;
import net.labymod.addons.customnametags.listener.ChatReceiveListener;
import net.labymod.addons.customnametags.listener.NameTagBackgroundRenderListener;
import net.labymod.addons.customnametags.listener.PlayerNameTagRenderListener;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.event.Event;
import net.labymod.api.event.client.gui.screen.playerlist.PlayerListUpdateEvent;
import net.labymod.api.models.addon.annotation.AddonMain;

@AddonMain
public class CustomNameTags
extends LabyAddon<CustomNameTagsConfiguration> {
    private static CustomNameTags instance;

    public CustomNameTags() {
        instance = this;
    }

    public static CustomNameTags get() {
        return instance;
    }

    protected void enable() {
        this.registerSettingCategory();
        ((CustomNameTagsConfiguration)this.configuration()).removeInvalidNameTags();
        this.registerListener(new ChatReceiveListener(this));
        this.registerListener(new NameTagBackgroundRenderListener(this));
        this.registerListener(new PlayerNameTagRenderListener(this));
        if (this.wasLoadedInRuntime()) {
            this.reloadTabList();
        }
    }

    protected Class<CustomNameTagsConfiguration> configurationClass() {
        return CustomNameTagsConfiguration.class;
    }

    public void reloadTabList() {
        this.labyAPI().eventBus().fire((Event)new PlayerListUpdateEvent());
    }

    public boolean replaceUsername(Component component, String playerName, Supplier<Component> customName) {
        TextComponent textComponent;
        String text;
        int next;
        boolean replaced = false;
        for (Component child : component.getChildren()) {
            if (!this.replaceUsername(child, playerName, customName)) continue;
            replaced = true;
        }
        if (component instanceof TranslatableComponent) {
            for (Component argument : ((TranslatableComponent)component).getArguments()) {
                if (!this.replaceUsername(argument, playerName, customName)) continue;
                replaced = true;
            }
        }
        if (component instanceof TextComponent && (next = (text = (textComponent = (TextComponent)component).getText()).indexOf(playerName)) != -1) {
            replaced = true;
            int length = text.length();
            if (next == 0) {
                if (length == playerName.length()) {
                    textComponent.text("");
                    component.append(0, customName.get());
                    return true;
                }
                if (length > playerName.length() && text.charAt(playerName.length()) != ' ') {
                    return false;
                }
            }
            textComponent.text("");
            int lastNameAt = 0;
            int childIndex = 0;
            for (int i = 0; i < length; ++i) {
                if (i != next) continue;
                if (i > lastNameAt) {
                    component.append(childIndex++, (Component)Component.text((String)text.substring(lastNameAt, i)));
                }
                component.append(childIndex++, customName.get());
                lastNameAt = i + playerName.length();
            }
            if (lastNameAt < length) {
                component.append(childIndex, (Component)Component.text((String)text.substring(lastNameAt)));
            }
        }
        return replaced;
    }
}

