/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags.gui.activity;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.labymod.addons.customnametags.CustomNameTag;
import net.labymod.addons.customnametags.CustomNameTags;
import net.labymod.addons.customnametags.CustomNameTagsConfiguration;
import net.labymod.addons.customnametags.gui.activity.NameTagWidget;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.LabyScreen;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.Links;
import net.labymod.api.client.gui.screen.key.InputType;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.render.font.TextColorStripper;
import org.jetbrains.annotations.Nullable;

@AutoActivity
@Links(value={@Link(value="manage.lss"), @Link(value="overview.lss")})
public class NameTagActivity
extends Activity {
    private static final Pattern NAME_PATTERN = Pattern.compile("[\\w]{0,16}");
    private static final TextColorStripper TEXT_COLOR_STRIPPER = Laby.references().textColorStripper();
    private final CustomNameTags addon = CustomNameTags.get();
    private final VerticalListWidget<NameTagWidget> nameTagList;
    private final Map<String, NameTagWidget> nameTagWidgets = new HashMap<String, NameTagWidget>();
    private NameTagWidget selectedNameTag;
    private ButtonWidget removeButton;
    private ButtonWidget editButton;
    private FlexibleContentWidget inputWidget;
    private String lastUserName;
    private String lastCustomName;
    private Action action;
    private boolean updateRequired;

    public NameTagActivity() {
        ((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().forEach((userName, customTag) -> this.nameTagWidgets.put((String)userName, new NameTagWidget((String)userName, (CustomNameTag)customTag)));
        this.nameTagList = new VerticalListWidget();
        this.nameTagList.addId("name-tag-list");
        this.nameTagList.setSelectCallback(nameTagWidget -> {
            NameTagWidget selectedNameTag = (NameTagWidget)((Object)((Object)this.nameTagList.session().getSelectedEntry()));
            if (selectedNameTag == null || selectedNameTag.getCustomTag() != nameTagWidget.getCustomTag()) {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        });
        this.nameTagList.setDoubleClickCallback(nameTagWidget -> this.setAction(Action.EDIT));
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = new FlexibleContentWidget();
        container.addId("name-tag-container");
        for (NameTagWidget nameTagWidget : this.nameTagWidgets.values()) {
            this.nameTagList.addChild((Widget)nameTagWidget);
        }
        container.addFlexibleContent((Widget)new ScrollWidget(this.nameTagList));
        this.selectedNameTag = (NameTagWidget)((Object)this.nameTagList.session().getSelectedEntry());
        HorizontalListWidget menu = new HorizontalListWidget();
        menu.addId("overview-button-menu");
        menu.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.add", () -> this.setAction(Action.ADD)));
        this.editButton = ButtonWidget.i18n((String)"labymod.ui.button.edit", () -> this.setAction(Action.EDIT));
        this.editButton.setEnabled(this.selectedNameTag != null);
        menu.addEntry((Widget)this.editButton);
        this.removeButton = ButtonWidget.i18n((String)"labymod.ui.button.remove", () -> this.setAction(Action.REMOVE));
        this.removeButton.setEnabled(this.selectedNameTag != null);
        menu.addEntry((Widget)this.removeButton);
        container.addContent((Widget)menu);
        ((Document)this.document()).addChild((Widget)container);
        if (this.action == null) {
            return;
        }
        DivWidget manageContainer = new DivWidget();
        manageContainer.addId("manage-container");
        manageContainer.addChild((Widget)(switch (this.action) {
            default -> {
                NameTagWidget newCustomNameTag = new NameTagWidget("", CustomNameTag.createDefault());
                yield this.initializeManageContainer(newCustomNameTag);
            }
            case Action.EDIT -> this.initializeManageContainer(this.selectedNameTag);
            case Action.REMOVE -> this.initializeRemoveContainer(this.selectedNameTag);
        }));
        ((Document)this.document()).addChild((Widget)manageContainer);
    }

    private FlexibleContentWidget initializeRemoveContainer(NameTagWidget nameTagWidget) {
        this.inputWidget = new FlexibleContentWidget();
        this.inputWidget.addId("remove-container");
        ComponentWidget confirmationWidget = ComponentWidget.i18n((String)"customnametags.gui.manage.remove.title");
        confirmationWidget.addId("remove-confirmation");
        this.inputWidget.addContent((Widget)confirmationWidget);
        NameTagWidget previewWidget = new NameTagWidget(nameTagWidget.getUserName(), nameTagWidget.getCustomTag());
        previewWidget.addId("remove-preview");
        this.inputWidget.addContent((Widget)previewWidget);
        HorizontalListWidget menu = new HorizontalListWidget();
        menu.addId("remove-button-menu");
        menu.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.remove", () -> {
            ((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().remove(nameTagWidget.getUserName());
            this.nameTagWidgets.remove(nameTagWidget.getUserName());
            this.nameTagList.session().setSelectedEntry(null);
            this.setAction(null);
            this.updateRequired = true;
        }));
        menu.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.cancel", () -> this.setAction(null)));
        this.inputWidget.addContent((Widget)menu);
        return this.inputWidget;
    }

    private DivWidget initializeManageContainer(NameTagWidget nameTagWidget) {
        TextFieldWidget customTextField = new TextFieldWidget();
        ButtonWidget doneButton = ButtonWidget.i18n((String)"labymod.ui.button.done");
        DivWidget inputContainer = new DivWidget();
        inputContainer.addId("input-container");
        ComponentWidget customNameWidget = ComponentWidget.component((Component)nameTagWidget.getCustomTag().displayName());
        customNameWidget.addId("custom-preview");
        inputContainer.addChild((Widget)customNameWidget);
        this.inputWidget = new FlexibleContentWidget();
        this.inputWidget.addId("input-list");
        ComponentWidget labelName = ComponentWidget.i18n((String)"customnametags.gui.manage.name");
        labelName.addId("label-name");
        this.inputWidget.addContent((Widget)labelName);
        HorizontalListWidget nameList = new HorizontalListWidget();
        nameList.addId("input-name-list");
        IconWidget iconWidget = new IconWidget(nameTagWidget.getIconWidget(nameTagWidget.getUserName()));
        iconWidget.addId("input-avatar");
        nameList.addEntry((Widget)iconWidget);
        TextFieldWidget nameTextField = new TextFieldWidget();
        nameTextField.maximalLength(16);
        nameTextField.setText(nameTagWidget.getUserName());
        nameTextField.validator(newValue -> NAME_PATTERN.matcher((CharSequence)newValue).matches());
        nameTextField.updateListener(newValue -> {
            doneButton.setEnabled(!newValue.trim().isEmpty() && !this.getStrippedText(customTextField.getText()).isEmpty());
            if (newValue.equals(this.lastUserName)) {
                return;
            }
            this.lastUserName = newValue;
            iconWidget.icon().set((Object)nameTagWidget.getIconWidget((String)newValue));
        });
        nameList.addEntry((Widget)nameTextField);
        this.inputWidget.addContent((Widget)nameList);
        ComponentWidget labelCustomName = ComponentWidget.i18n((String)"customnametags.gui.manage.custom.name");
        labelCustomName.addId("label-name");
        this.inputWidget.addContent((Widget)labelCustomName);
        HorizontalListWidget customNameList = new HorizontalListWidget();
        customNameList.addId("input-name-list");
        DivWidget placeHolder = new DivWidget();
        placeHolder.addId("input-avatar");
        customNameList.addEntry((Widget)placeHolder);
        customTextField.maximalLength(64);
        customTextField.setText(nameTagWidget.getCustomTag().getCustomName());
        customTextField.updateListener(newValue -> {
            doneButton.setEnabled(!this.getStrippedText((String)newValue).isEmpty() && !nameTextField.getText().trim().isEmpty());
            if (newValue.equals(this.lastCustomName)) {
                return;
            }
            this.lastCustomName = newValue;
            customNameWidget.setComponent(LegacyComponentSerializer.legacyAmpersand().deserialize(newValue));
        });
        customNameList.addEntry((Widget)customTextField);
        this.inputWidget.addContent((Widget)customNameList);
        HorizontalListWidget checkBoxList = new HorizontalListWidget();
        checkBoxList.addId("checkbox-list");
        DivWidget enabledDiv = new DivWidget();
        enabledDiv.addId("checkbox-div");
        ComponentWidget enabledText = ComponentWidget.i18n((String)"customnametags.gui.manage.enabled.name");
        enabledText.addId("checkbox-name");
        enabledDiv.addChild((Widget)enabledText);
        CheckBoxWidget enabledWidget = new CheckBoxWidget();
        enabledWidget.addId("checkbox-item");
        enabledWidget.setState(nameTagWidget.getCustomTag().isEnabled() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        enabledDiv.addChild((Widget)enabledWidget);
        checkBoxList.addEntry((Widget)enabledDiv);
        DivWidget replaceDiv = new DivWidget();
        replaceDiv.addId("checkbox-div");
        ComponentWidget replaceText = ComponentWidget.i18n((String)"customnametags.gui.manage.replace.name");
        replaceText.addId("checkbox-name");
        replaceDiv.addChild((Widget)replaceText);
        CheckBoxWidget replaceWidget = new CheckBoxWidget();
        replaceWidget.addId("checkbox-item");
        replaceWidget.setState(nameTagWidget.getCustomTag().isReplaceScoreboard() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        replaceDiv.addChild((Widget)replaceWidget);
        checkBoxList.addEntry((Widget)replaceDiv);
        this.inputWidget.addContent((Widget)checkBoxList);
        HorizontalListWidget buttonList = new HorizontalListWidget();
        buttonList.addId("edit-button-menu");
        doneButton.setEnabled(!nameTextField.getText().trim().isEmpty() && !this.getStrippedText(customTextField.getText()).isEmpty());
        doneButton.setPressable(() -> {
            if (nameTagWidget.getUserName().length() == 0) {
                this.nameTagWidgets.put(nameTextField.getText(), nameTagWidget);
                this.nameTagList.session().setSelectedEntry((Object)nameTagWidget);
            }
            ((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().remove(nameTagWidget.getUserName());
            CustomNameTag customNameTag = nameTagWidget.getCustomTag();
            customNameTag.setCustomName(customTextField.getText());
            customNameTag.setEnabled(enabledWidget.state() == CheckBoxWidget.State.CHECKED);
            customNameTag.setReplaceScoreboard(replaceWidget.state() == CheckBoxWidget.State.CHECKED);
            ((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().put(nameTextField.getText(), customNameTag);
            ((CustomNameTagsConfiguration)this.addon.configuration()).removeInvalidNameTags();
            nameTagWidget.setUserName(nameTextField.getText());
            nameTagWidget.setCustomTag(customNameTag);
            this.setAction(null);
            this.updateRequired = true;
        });
        buttonList.addEntry((Widget)doneButton);
        buttonList.addEntry((Widget)ButtonWidget.i18n((String)"labymod.ui.button.cancel", () -> this.setAction(null)));
        inputContainer.addChild((Widget)this.inputWidget);
        this.inputWidget.addContent((Widget)buttonList);
        return inputContainer;
    }

    private String getStrippedText(String text) {
        if ((text = text.trim()).isEmpty()) {
            return text;
        }
        return TEXT_COLOR_STRIPPER.stripColorCodes(text, '&');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        block3: {
            boolean bl;
            try {
                if (this.action == null) break block3;
                bl = this.inputWidget.mouseClicked(mouse, mouseButton);
            }
            catch (Throwable throwable) {
                this.selectedNameTag = (NameTagWidget)((Object)this.nameTagList.session().getSelectedEntry());
                this.removeButton.setEnabled(this.selectedNameTag != null);
                this.editButton.setEnabled(this.selectedNameTag != null);
                throw throwable;
            }
            this.selectedNameTag = (NameTagWidget)((Object)this.nameTagList.session().getSelectedEntry());
            this.removeButton.setEnabled(this.selectedNameTag != null);
            this.editButton.setEnabled(this.selectedNameTag != null);
            return bl;
        }
        boolean bl = super.mouseClicked(mouse, mouseButton);
        this.selectedNameTag = (NameTagWidget)((Object)this.nameTagList.session().getSelectedEntry());
        this.removeButton.setEnabled(this.selectedNameTag != null);
        this.editButton.setEnabled(this.selectedNameTag != null);
        return bl;
    }

    public boolean keyPressed(Key key, InputType type) {
        if (key.getId() == 256 && this.action != null) {
            this.setAction(null);
            return true;
        }
        return super.keyPressed(key, type);
    }

    private void setAction(Action action) {
        this.action = action;
        this.reload();
    }

    @Nullable
    public <T extends LabyScreen> T renew() {
        return null;
    }

    public void onCloseScreen() {
        super.onCloseScreen();
        if (this.updateRequired) {
            this.addon.reloadTabList();
        }
    }

    private static enum Action {
        ADD,
        EDIT,
        REMOVE;

    }
}

