/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags.gui.popup;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.labymod.addons.customnametags.CustomNameTag;
import net.labymod.addons.customnametags.CustomNameTagsConfiguration;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.popup.SimpleAdvancedPopup;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.render.font.TextColorStripper;
import net.labymod.api.event.Event;
import net.labymod.api.event.client.gui.screen.playerlist.PlayerListUpdateEvent;
import org.jetbrains.annotations.NotNull;

@Link(value="manage.lss")
public class EditNameTagPopup
extends SimpleAdvancedPopup {
    private static final Pattern NAME_PATTERN = Pattern.compile("\\w{0,16}");
    private static final TextColorStripper TEXT_COLOR_STRIPPER = Laby.references().textColorStripper();
    private String lastUserName;
    private final SimpleAdvancedPopup.SimplePopupButton confirmButton;
    private TextFieldWidget mcNameInput;
    private TextFieldWidget customNameInput;
    private CheckBoxWidget enabledCheckBox;
    private CheckBoxWidget replaceCheckBox;

    public EditNameTagPopup(@NotNull CustomNameTag nameTag, @NotNull CustomNameTagsConfiguration config, @NotNull Consumer<CustomNameTag> onDataChange) {
        DivWidget inputContainer = new DivWidget();
        inputContainer.addId("input-container");
        ComponentWidget customNamePreview = ComponentWidget.component((Component)nameTag.displayName());
        customNamePreview.addId("custom-preview");
        inputContainer.addChild((Widget)customNamePreview);
        FlexibleContentWidget inputWidget = new FlexibleContentWidget();
        inputWidget.addId("input-list");
        this.buildOriginalInputArea(inputWidget, nameTag);
        this.buildCustomNameInputArea(inputWidget, customNamePreview, nameTag);
        this.buildCheckboxArea(inputWidget, nameTag);
        inputContainer.addChild((Widget)inputWidget);
        this.title = Component.translatable((String)("customnametags.gui.manage." + (nameTag.getOriginalName().isEmpty() ? "add" : "edit")), (Component[])new Component[0]);
        this.widgetFunction = container -> container.addChild((Widget)inputContainer);
        this.buttons = new ArrayList();
        this.confirmButton = SimpleAdvancedPopup.SimplePopupButton.create((Component)Component.translatable((String)"labymod.ui.button.done", (Component[])new Component[0]), ignored -> {
            nameTag.setEnabled(this.enabledCheckBox.state() == CheckBoxWidget.State.CHECKED);
            nameTag.setReplaceScoreboard(this.replaceCheckBox.state() == CheckBoxWidget.State.CHECKED);
            nameTag.setOriginalName(this.mcNameInput.getText());
            nameTag.setCustomName(this.customNameInput.getText());
            Map<String, CustomNameTag> customTags = config.getCustomTags();
            customTags.remove(nameTag.getOriginalName());
            customTags.put(nameTag.getOriginalName(), nameTag);
            onDataChange.accept(nameTag);
            Laby.fireEvent((Event)new PlayerListUpdateEvent());
        });
        this.buttons.add(this.confirmButton);
        this.buttons.add(SimpleAdvancedPopup.SimplePopupButton.cancel());
    }

    private void buildOriginalInputArea(@NotNull FlexibleContentWidget parent, @NotNull CustomNameTag nameTag) {
        IconWidget icon = new IconWidget(this.getPlayerHead(nameTag.getOriginalName()));
        this.mcNameInput = this.buildInputArea(parent, "customnametags.gui.manage.name", (Widget)icon, nameTag.getOriginalName(), newValue -> icon.icon().set((Object)this.getPlayerHead((String)newValue)));
    }

    private void buildCustomNameInputArea(@NotNull FlexibleContentWidget parent, @NotNull ComponentWidget customNamePreview, @NotNull CustomNameTag nameTag) {
        this.customNameInput = this.buildInputArea(parent, "customnametags.gui.manage.custom.name", (Widget)new DivWidget(), nameTag.getCustomName(), newValue -> customNamePreview.setComponent(LegacyComponentSerializer.legacyAmpersand().deserialize(newValue)));
    }

    @NotNull
    private TextFieldWidget buildInputArea(@NotNull FlexibleContentWidget parent, @NotNull String translationKey, @NotNull Widget iconWidget, @NotNull String defaultValue, @NotNull Consumer<String> changeConsumer) {
        ComponentWidget label = ComponentWidget.i18n((String)translationKey);
        label.addId("label-name");
        parent.addContent((Widget)label);
        HorizontalListWidget list = new HorizontalListWidget();
        list.addId("input-name-list");
        iconWidget.addId("input-avatar");
        list.addEntry(iconWidget);
        TextFieldWidget input = new TextFieldWidget();
        input.maximalLength(64);
        input.setText(defaultValue);
        input.updateListener(newValue -> {
            this.updateConfirmButtonState();
            changeConsumer.accept((String)newValue);
        });
        list.addEntry((Widget)input);
        parent.addContent((Widget)list);
        return input;
    }

    private void buildCheckboxArea(@NotNull FlexibleContentWidget parent, @NotNull CustomNameTag nameTag) {
        FlexibleContentWidget checkBoxList = new FlexibleContentWidget();
        checkBoxList.addId("checkbox-list");
        this.enabledCheckBox = this.buildSingleCheckboxes(checkBoxList, "customnametags.gui.manage.enabled.name", nameTag.isEnabled());
        this.replaceCheckBox = this.buildSingleCheckboxes(checkBoxList, "customnametags.gui.manage.replace.name", nameTag.isReplaceScoreboard());
        parent.addContent((Widget)checkBoxList);
    }

    @NotNull
    private CheckBoxWidget buildSingleCheckboxes(@NotNull FlexibleContentWidget parent, @NotNull String translationKey, boolean defaultValue) {
        FlexibleContentWidget div = new FlexibleContentWidget();
        div.addId("checkbox-div");
        ComponentWidget text = ComponentWidget.i18n((String)translationKey);
        text.addId("checkbox-name");
        CheckBoxWidget checkBox = new CheckBoxWidget();
        checkBox.addId("checkbox-item");
        checkBox.setState(defaultValue ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        div.addContent((Widget)checkBox);
        div.addContent((Widget)text);
        parent.addContent((Widget)div);
        return checkBox;
    }

    private void updateConfirmButtonState() {
        this.confirmButton.enabled(!this.mcNameInput.getText().isBlank() && !this.customNameInput.getText().isBlank());
    }

    @NotNull
    private Icon getPlayerHead(@NotNull String userName) {
        return Icon.head((String)(userName.isEmpty() ? "MHF_Question" : userName));
    }
}

