/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags;

import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class CustomNameTag {
    private String originalName;
    private boolean enabled;
    private String customName;
    private boolean replaceScoreboard;
    private transient Component displayName;

    @NotNull
    public static CustomNameTag of(@NotNull String originalName, @NotNull String customName, boolean enabled, boolean replaceScoreboard) {
        return new CustomNameTag(originalName, customName, enabled, replaceScoreboard);
    }

    @NotNull
    public static CustomNameTag ofDefault() {
        return CustomNameTag.of("", "", true, false);
    }

    private CustomNameTag(@NotNull String originalName, @NotNull String customName, boolean enabled, boolean replaceScoreboard) {
        this.enabled = enabled;
        this.originalName = originalName;
        this.customName = customName;
        this.replaceScoreboard = replaceScoreboard;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        if (this.customName.equals(customName)) {
            return;
        }
        this.customName = customName;
        this.displayName = null;
    }

    public boolean isReplaceScoreboard() {
        return this.replaceScoreboard;
    }

    public void setReplaceScoreboard(boolean replaceScoreboard) {
        this.replaceScoreboard = replaceScoreboard;
    }

    public Component displayName() {
        if (this.displayName == null) {
            this.displayName = LegacyComponentSerializer.legacyAmpersand().deserialize(this.customName);
        }
        return this.displayName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getOriginalName() {
        return this.originalName;
    }
}

