/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.labymod.addons.customnametags.CustomNameTagsConfiguration;
import net.labymod.addons.customnametags.listener.ChatReceiveListener;
import net.labymod.addons.customnametags.listener.ConfigVersionUpdateListener;
import net.labymod.addons.customnametags.listener.NameTagBackgroundRenderListener;
import net.labymod.addons.customnametags.listener.PlayerNameTagRenderListener;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.Style;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import net.labymod.api.event.Event;
import net.labymod.api.event.client.gui.screen.playerlist.PlayerListUpdateEvent;
import net.labymod.api.models.addon.annotation.AddonMain;

@AddonMain
public class CustomNameTags
extends LabyAddon<CustomNameTagsConfiguration> {
    private static CustomNameTags instance;

    public CustomNameTags() {
        instance = this;
    }

    public static CustomNameTags get() {
        return instance;
    }

    protected void preConfigurationLoad() {
        this.registerListener(new ConfigVersionUpdateListener());
    }

    protected void enable() {
        this.registerSettingCategory();
        ((CustomNameTagsConfiguration)this.configuration()).removeInvalidNameTags();
        this.registerListener(new ChatReceiveListener(this));
        this.registerListener(new NameTagBackgroundRenderListener(this));
        this.registerListener(new PlayerNameTagRenderListener(this));
        if (this.wasLoadedInRuntime()) {
            this.reloadTabList();
        }
    }

    protected Class<CustomNameTagsConfiguration> configurationClass() {
        return CustomNameTagsConfiguration.class;
    }

    public void reloadTabList() {
        this.labyAPI().eventBus().fire((Event)new PlayerListUpdateEvent());
    }

    public boolean replaceUsername(Component component, String playerName, Supplier<Component> customName) {
        TextComponent textComponent;
        String text;
        int next;
        boolean replaced = false;
        for (Component child : component.getChildren()) {
            if (!this.replaceUsername(child, playerName, customName)) continue;
            replaced = true;
        }
        if (component instanceof TranslatableComponent) {
            for (Component argument : ((TranslatableComponent)component).getArguments()) {
                if (!this.replaceUsername(argument, playerName, customName)) continue;
                replaced = true;
            }
        }
        if (component instanceof TextComponent && (next = (text = (textComponent = (TextComponent)component).getText()).indexOf(playerName)) != -1) {
            replaced = true;
            int length = text.length();
            if (next == 0 && length == playerName.length()) {
                textComponent.text("");
                component.append(0, customName.get());
                return true;
            }
            textComponent.text("");
            int lastNameAt = 0;
            int childIndex = 0;
            for (int i = 0; i < length; ++i) {
                if (i != next) continue;
                int nameEndsAt = i + playerName.length();
                next = text.indexOf(playerName, nameEndsAt);
                if (i != 0 && text.charAt(i - 1) != ' ' || nameEndsAt < length && text.charAt(nameEndsAt) != ' ') continue;
                if (i > lastNameAt) {
                    component.append(childIndex++, (Component)Component.text((String)text.substring(lastNameAt, i)));
                }
                component.append(childIndex++, customName.get());
                lastNameAt = nameEndsAt;
                if (next == -1) break;
            }
            if (lastNameAt < length) {
                component.append(childIndex, (Component)Component.text((String)text.substring(lastNameAt)));
            }
        }
        return replaced;
    }

    public Component replaceLegacyContext(Component component) {
        TextComponent textComponent;
        String text;
        ArrayList<Component> children = new ArrayList<Component>();
        for (Component child : component.getChildren()) {
            children.add(this.replaceLegacyContext(child));
        }
        component.setChildren(children);
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            ArrayList<Component> arguments = new ArrayList<Component>();
            for (Component argument : translatableComponent.getArguments()) {
                arguments.add(this.replaceLegacyContext(argument));
            }
            translatableComponent.arguments(arguments);
        }
        if (component instanceof TextComponent && (text = (textComponent = (TextComponent)component).getText()).indexOf(167) != -1) {
            Style style = component.style();
            component = LegacyComponentSerializer.legacySection().deserialize(text);
            component.style(component.style().merge(style, Style.Merge.Strategy.IF_ABSENT_ON_TARGET));
        }
        return component;
    }
}

