/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags.listener;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.labymod.addons.customnametags.CustomNameTag;
import net.labymod.addons.customnametags.CustomNameTags;
import net.labymod.addons.customnametags.CustomNameTagsConfiguration;
import net.labymod.api.client.component.Component;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.chat.ChatReceiveEvent;
import net.labymod.api.event.client.render.PlayerNameTagRenderEvent;

public class ChatReceiveListener {
    private final CustomNameTags addon;

    public ChatReceiveListener(CustomNameTags addon) {
        this.addon = addon;
    }

    @Subscribe(value=126)
    public void onChatReceive(ChatReceiveEvent event) {
        Component message = event.message();
        boolean replaced = false;
        Set<Map.Entry<String, CustomNameTag>> entries = ((CustomNameTagsConfiguration)this.addon.configuration()).getCustomTags().entrySet();
        boolean hasName = false;
        String formattedText = event.chatMessage().getFormattedText();
        String lowercaseFormattedText = formattedText.toLowerCase(Locale.ROOT);
        for (Map.Entry<String, CustomNameTag> entry : entries) {
            if (!entry.getValue().isEnabled() || !lowercaseFormattedText.contains(entry.getKey().toLowerCase(Locale.ROOT))) continue;
            hasName = true;
            break;
        }
        if (!hasName) {
            return;
        }
        message = this.addon.replaceLegacyContext(message);
        for (Map.Entry<String, CustomNameTag> customTagEntry : entries) {
            if (!customTagEntry.getValue().isEnabled() || !this.addon.replaceUsername(message, customTagEntry.getKey(), () -> ((CustomNameTag)customTagEntry.getValue()).displayName().copy())) continue;
            replaced = true;
        }
        if (replaced) {
            message.append((Component)PlayerNameTagRenderEvent.EDITED_COMPONENT);
        }
        event.setMessage(message);
    }
}

