/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.customnametags.listener;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.labymod.config.ConfigurationVersionUpdateEvent;
import net.labymod.api.util.logging.Logging;
import org.jetbrains.annotations.NotNull;

public class ConfigVersionUpdateListener {
    private Logging logger = null;

    @Subscribe
    public void onConfigVersionUpdate(ConfigurationVersionUpdateEvent event) {
        if (this.logger == null) {
            this.logger = Logging.getLogger();
        }
        this.logger.info((CharSequence)("Config update detected, current version: " + event.getUsedVersion() + ", required version: " + event.getIntendedVersion()), new Object[0]);
        JsonObject object = event.getJsonObject();
        this.mapVersion1ToVersion2(object);
        event.setJsonObject(object);
    }

    private void mapVersion1ToVersion2(@NotNull JsonObject jsonObject) {
        JsonElement customTags = jsonObject.get("customTags");
        if (customTags == null || customTags.isJsonNull()) {
            this.logger.warn((CharSequence)"Could not find customTags in config.json, updating of config to version 2 failed.", new Object[0]);
            return;
        }
        for (Map.Entry entry : customTags.getAsJsonObject().entrySet()) {
            JsonElement customTag = (JsonElement)entry.getValue();
            if (customTag.isJsonNull() || !customTag.isJsonObject()) {
                this.logger.warn((CharSequence)("Invalid customTag in config.json, updating of config to version 2 failed for entry " + (String)entry.getKey() + "."), new Object[0]);
                continue;
            }
            customTag.getAsJsonObject().addProperty("originalName", (String)entry.getKey());
        }
        this.logger.info((CharSequence)"Updated config to version 2.", new Object[0]);
    }
}

