/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.damageindicator.tags;

import net.labymod.addons.damageindicator.DamageIndicator;
import net.labymod.addons.damageindicator.DamageIndicatorConfiguration;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.Entity;
import net.labymod.api.client.entity.LivingEntity;
import net.labymod.api.client.entity.player.tag.tags.NameTag;
import net.labymod.api.client.render.RenderPipeline;
import net.labymod.api.client.render.draw.ResourceRenderer;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.client.render.matrix.Stack;

public abstract class ComponentWithHeartTag
extends NameTag {
    private final RenderPipeline renderPipeline;
    private final ResourceRenderer resourceRenderer;
    private final DamageIndicatorConfiguration configuration;
    private final DamageIndicatorConfiguration.DisplayType displayType;
    private float startX;

    protected ComponentWithHeartTag(DamageIndicator damageIndicator, DamageIndicatorConfiguration.DisplayType displayType) {
        this.renderPipeline = damageIndicator.labyAPI().renderPipeline();
        this.resourceRenderer = this.renderPipeline.resourceRenderer();
        this.configuration = (DamageIndicatorConfiguration)damageIndicator.configuration();
        this.displayType = displayType;
    }

    public void render(Stack stack, Entity entity) {
        super.render(stack, entity);
        RenderPipeline renderPipeline = this.renderPipeline;
        renderPipeline.renderNoneStandardNameTag(entity, () -> {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.resourceRenderer.entityHeartRenderer(livingEntity).renderHealthBar(stack, this.startX, this.getHeight() / 2.0f - 4.0f, 8, 2, 2);
        });
    }

    protected RenderableComponent getRenderableComponent() {
        if (!(this.entity instanceof LivingEntity) || this.entity.isCrouching() || !this.configuration.isVisible(this.displayType)) {
            return null;
        }
        RenderableComponent renderableComponent = RenderableComponent.of((Component)this.component((LivingEntity)this.entity));
        this.startX = renderableComponent.getWidth() + 2.0f;
        return renderableComponent;
    }

    public float getWidth() {
        return super.getWidth() + 9.0f;
    }

    public float getScale() {
        return 0.7f;
    }

    protected boolean withDepthTest() {
        return false;
    }

    public boolean isVisible() {
        return super.isVisible() && !this.entity.entityId().equals((Object)DamageIndicator.ARMOR_STAND);
    }

    protected abstract Component component(LivingEntity var1);
}

