/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.damageindicator.tags;

import net.labymod.addons.damageindicator.DamageIndicator;
import net.labymod.addons.damageindicator.DamageIndicatorConfiguration;
import net.labymod.api.client.entity.Entity;
import net.labymod.api.client.entity.LivingEntity;
import net.labymod.api.client.entity.player.tag.renderer.AbstractTagRenderer;
import net.labymod.api.client.render.RenderPipeline;
import net.labymod.api.client.render.draw.ResourceRenderer;
import net.labymod.api.client.render.matrix.Stack;

public final class HealthBarTag
extends AbstractTagRenderer {
    private final RenderPipeline renderPipeline;
    private final ResourceRenderer resourceRenderer;
    private final DamageIndicatorConfiguration configuration;

    public HealthBarTag(DamageIndicator damageIndicator) {
        this.renderPipeline = damageIndicator.labyAPI().renderPipeline();
        this.resourceRenderer = this.renderPipeline.resourceRenderer();
        this.configuration = (DamageIndicatorConfiguration)damageIndicator.configuration();
    }

    public void render(Stack stack, Entity entity) {
        RenderPipeline renderPipeline = this.renderPipeline;
        renderPipeline.renderNoneStandardNameTag(entity, () -> this.resourceRenderer.entityHeartRenderer((LivingEntity)entity).renderHealthBar(stack, 0.0f, 0.0f, 16));
    }

    public boolean isVisible() {
        return this.entity instanceof LivingEntity && !this.entity.isCrouching() && this.configuration.isVisible(DamageIndicatorConfiguration.DisplayType.HEALTH_BAR) && !this.entity.entityId().equals((Object)DamageIndicator.ARMOR_STAND);
    }

    public float getWidth() {
        return this.resourceRenderer.entityHeartRenderer((LivingEntity)this.entity).getWidth(16);
    }

    public float getHeight() {
        return 16.0f;
    }

    public float getScale() {
        return 0.4f;
    }
}

