/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.damageindicator.tags;

import net.labymod.addons.damageindicator.DamageIndicator;
import net.labymod.addons.damageindicator.DamageIndicatorConfiguration;
import net.labymod.addons.damageindicator.snapshot.DamageIndicatorExtraKeys;
import net.labymod.addons.damageindicator.snapshot.HealthStatusSnapshot;
import net.labymod.addons.damageindicator.tags.ComponentWithHeartTag;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.render.state.entity.LivingEntitySnapshot;
import net.labymod.api.util.HealthStatus;

public class HealthAmountTag
extends ComponentWithHeartTag {
    public HealthAmountTag(DamageIndicator damageIndicator) {
        super(damageIndicator, DamageIndicatorConfiguration.DisplayType.AMOUNT);
    }

    @Override
    protected Component createComponent(LivingEntitySnapshot snapshot) {
        HealthStatusSnapshot healthStatusSnapshot = (HealthStatusSnapshot)((Object)snapshot.get(DamageIndicatorExtraKeys.HEALTH_STATUS));
        HealthStatus healthStatus = healthStatusSnapshot.healthStatus();
        double health = Math.ceil(healthStatus.getHealth()) / 2.0;
        double maxHealth = Math.ceil(healthStatus.getMaxHealth()) / 2.0;
        return Component.text((String)(this.formatDouble(health) + "/" + this.formatDouble(maxHealth)));
    }

    private String formatDouble(double value) {
        if (value == (double)((int)value)) {
            return String.format("%d", (int)value);
        }
        return String.format("%s", value);
    }
}

