/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.damageindicator.tags;

import java.util.Collections;
import java.util.List;
import net.labymod.addons.damageindicator.DamageIndicator;
import net.labymod.addons.damageindicator.DamageIndicatorConfiguration;
import net.labymod.addons.damageindicator.snapshot.DamageIndicatorExtraKeys;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.player.tag.tags.ComponentNameTag;
import net.labymod.api.client.render.draw.HeartRenderer;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import net.labymod.api.client.render.state.entity.LivingEntitySnapshot;
import net.labymod.api.laby3d.pipeline.RenderStates;
import net.labymod.api.laby3d.pipeline.material.LevelMaterial;
import net.labymod.api.laby3d.render.queue.CustomGeometryRenderer;
import net.labymod.api.laby3d.render.queue.SubmissionCollector;
import net.labymod.api.laby3d.render.queue.submissions.IconSubmission;
import net.labymod.api.util.HealthStatus;
import net.labymod.laby3d.api.pipeline.RenderState;
import net.labymod.laby3d.api.vertex.VertexConsumer;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public abstract class ComponentWithHeartTag
extends ComponentNameTag {
    private static final HealthStatus DEFAULT_STATUS = HealthStatus.immutable((float)2.0f, (float)2.0f);
    private static final float DEFAULT_BACKGROUND_DEPTH = -0.003f;
    private final HeartRenderer heartRenderer;
    private final DamageIndicatorConfiguration configuration;
    private final DamageIndicatorConfiguration.DisplayType displayType;

    protected ComponentWithHeartTag(DamageIndicator damageIndicator, DamageIndicatorConfiguration.DisplayType displayType) {
        this.displayType = displayType;
        this.heartRenderer = Laby.references().heartRenderer();
        this.configuration = (DamageIndicatorConfiguration)damageIndicator.configuration();
    }

    public void render(Stack stack, SubmissionCollector submissionCollector, EntitySnapshot snapshot) {
        submissionCollector.submitCustomGeometry(stack, LevelMaterial.builder((RenderState)RenderStates.GUI).build(), (CustomGeometryRenderer)new ColoredRectangle(0.0f, 0.0f, this.getWidth() + 2.0f, this.getHeight(), -0.003f, super.getBackgroundColor(snapshot)));
        super.render(stack, submissionCollector, snapshot);
        this.heartRenderer.submitHealthBar(stack, submissionCollector, IconSubmission.DisplayMode.NORMAL, this.getWidth() - 9.0f + 2.0f, this.getHeight() / 2.0f - 4.0f, 8, DEFAULT_STATUS);
    }

    @NotNull
    protected List<Component> buildComponents(EntitySnapshot snapshot) {
        LivingEntitySnapshot livingEntitySnapshot;
        block5: {
            block4: {
                if (!(snapshot instanceof LivingEntitySnapshot)) break block4;
                livingEntitySnapshot = (LivingEntitySnapshot)snapshot;
                if (!snapshot.isDiscrete() && this.configuration.isVisible(this.displayType)) break block5;
            }
            return super.buildComponents(snapshot);
        }
        if (!snapshot.has(DamageIndicatorExtraKeys.HEALTH_STATUS)) {
            return super.buildComponents(snapshot);
        }
        return Collections.singletonList(this.createComponent(livingEntitySnapshot));
    }

    public float getWidth() {
        return super.getWidth() + 9.0f;
    }

    public float getScale() {
        return 0.7f;
    }

    protected int getBackgroundColor(EntitySnapshot snapshot) {
        return 0;
    }

    protected abstract Component createComponent(LivingEntitySnapshot var1);

    static class ColoredRectangle
    implements CustomGeometryRenderer {
        private final float left;
        private final float top;
        private final float right;
        private final float bottom;
        private final float depth;
        private final int argb;

        public ColoredRectangle(float left, float top, float right, float bottom, float depth, int argb) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.depth = depth;
            this.argb = argb;
        }

        public void render(Matrix4f pose, VertexConsumer consumer) {
            consumer.addVertex(pose, this.left, this.top, this.depth).setBlankUv().setColor(this.argb);
            consumer.addVertex(pose, this.left, this.bottom, this.depth).setBlankUv().setColor(this.argb);
            consumer.addVertex(pose, this.right, this.bottom, this.depth).setBlankUv().setColor(this.argb);
            consumer.addVertex(pose, this.right, this.top, this.depth).setBlankUv().setColor(this.argb);
        }
    }
}

