/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.damageindicator.tags;

import net.labymod.addons.damageindicator.DamageIndicator;
import net.labymod.addons.damageindicator.DamageIndicatorConfiguration;
import net.labymod.addons.damageindicator.snapshot.DamageIndicatorExtraKeys;
import net.labymod.addons.damageindicator.snapshot.HealthStatusSnapshot;
import net.labymod.api.Laby;
import net.labymod.api.client.entity.player.tag.renderer.AbstractTagRenderer;
import net.labymod.api.client.render.draw.HeartRenderer;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import net.labymod.api.client.render.state.entity.LivingEntitySnapshot;
import net.labymod.api.laby3d.render.queue.SubmissionCollector;
import net.labymod.api.laby3d.render.queue.submissions.IconSubmission;

public final class HealthBarTag
extends AbstractTagRenderer {
    private static final int DEFAULT_SIZE = 16;
    private final HeartRenderer heartRenderer = Laby.references().heartRenderer();
    private final DamageIndicatorConfiguration configuration;

    public HealthBarTag(DamageIndicator damageIndicator) {
        this.configuration = (DamageIndicatorConfiguration)damageIndicator.configuration();
    }

    public void render(Stack stack, SubmissionCollector submissionCollector, EntitySnapshot snapshot) {
        this.heartRenderer.submitHealthBar(stack, submissionCollector, IconSubmission.DisplayMode.NORMAL, 0.0f, 0.0f, 16, ((HealthStatusSnapshot)((Object)snapshot.get(DamageIndicatorExtraKeys.HEALTH_STATUS))).healthStatus());
    }

    public boolean isVisible() {
        LivingEntitySnapshot livingSnapshot;
        EntitySnapshot entitySnapshot = this.snapshot;
        return entitySnapshot instanceof LivingEntitySnapshot && (livingSnapshot = (LivingEntitySnapshot)entitySnapshot).has(DamageIndicatorExtraKeys.HEALTH_STATUS) && !livingSnapshot.isDiscrete() && this.configuration.isVisible(DamageIndicatorConfiguration.DisplayType.HEALTH_BAR);
    }

    public float getWidth() {
        HealthStatusSnapshot healthStatusSnapshot = (HealthStatusSnapshot)((Object)this.snapshot.get(DamageIndicatorExtraKeys.HEALTH_STATUS));
        return this.heartRenderer.getWidth(healthStatusSnapshot.healthStatus(), 16);
    }

    public float getHeight() {
        return 16.0f;
    }

    public float getScale() {
        return 0.4f;
    }
}

