/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.deathfinder.core.commands;

import com.rappytv.deathfinder.api.util.DeathLocation;
import com.rappytv.deathfinder.core.DeathFinderAddon;
import com.rappytv.deathfinder.core.config.DeathFinderConfig;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import net.labymod.addons.waypoints.WaypointService;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.waypoint.WaypointBuilder;
import net.labymod.addons.waypoints.waypoint.WaypointType;
import net.labymod.api.Laby;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.chat.command.SubCommand;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.util.Color;

public class DeathFinderCommand
extends Command {
    public DeathFinderCommand(DeathFinderAddon addon) {
        super("deathfinder", new String[]{"df"});
        this.withSubCommand(new BackCommand());
        this.withSubCommand(new CoordsCommand());
        this.withSubCommand(new WaypointCommand(addon));
    }

    public boolean execute(String prefix, String[] arguments) {
        this.displayMessage(((TextComponent)Component.empty().append(DeathFinderAddon.prefix())).append((Component)Component.translatable((String)"deathfinder.command.usage", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{Component.text((String)("/" + prefix + " <back/coords/waypoint>"), (TextColor)NamedTextColor.AQUA)})));
        return true;
    }

    private static class BackCommand
    extends SubCommand {
        public BackCommand() {
            super("back", new String[0]);
        }

        public boolean execute(String prefix, String[] arguments) {
            if (DeathFinderAddon.references().deathManager().getLocation() == null) {
                this.displayMessage(((TextComponent)Component.empty().append(DeathFinderAddon.prefix())).append((Component)Component.translatable((String)"deathfinder.command.noSavedPoint", (TextColor)NamedTextColor.RED)));
                return true;
            }
            DeathLocation death = DeathFinderAddon.references().deathManager().getLocation();
            Laby.references().chatExecutor().chat(String.format("/tp @p %s %s %s %s %s", death.getX(), death.getY(), death.getZ(), death.getYaw(), death.getPitch()), false);
            return true;
        }
    }

    private static class CoordsCommand
    extends SubCommand {
        private final DecimalFormat decimalFormat = new DecimalFormat("#.##");

        public CoordsCommand() {
            super("coords", new String[0]);
        }

        public boolean execute(String prefix, String[] arguments) {
            if (DeathFinderAddon.references().deathManager().getLocation() == null) {
                this.displayMessage(((TextComponent)Component.empty().append(DeathFinderAddon.prefix())).append((Component)Component.translatable((String)"deathfinder.command.noSavedPoint", (TextColor)NamedTextColor.RED)));
                return true;
            }
            DeathLocation death = DeathFinderAddon.references().deathManager().getLocation();
            this.displayMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(DeathFinderAddon.prefix())).append((Component)Component.translatable((String)"deathfinder.command.coords.success", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.newline())).append(DeathFinderAddon.prefix())).append((Component)Component.text((String)"X: ", (TextColor)NamedTextColor.GREEN))).append(this.formatValue(death.getX()))).append((Component)Component.newline())).append(DeathFinderAddon.prefix())).append((Component)Component.text((String)"Y: ", (TextColor)NamedTextColor.GREEN))).append(this.formatValue(death.getY()))).append((Component)Component.newline())).append(DeathFinderAddon.prefix())).append((Component)Component.text((String)"Z: ", (TextColor)NamedTextColor.GREEN))).append(this.formatValue(death.getZ()))).append((Component)Component.newline())).append(DeathFinderAddon.prefix())).append((Component)Component.text((String)"Yaw: ", (TextColor)NamedTextColor.GREEN))).append(this.formatValue(death.getYaw()))).append((Component)Component.newline())).append(DeathFinderAddon.prefix())).append((Component)Component.text((String)"Pitch: ", (TextColor)NamedTextColor.GREEN))).append(this.formatValue(death.getPitch())));
            return true;
        }

        private Component formatValue(double value) {
            return Component.text((String)this.decimalFormat.format(value), (TextColor)NamedTextColor.AQUA);
        }
    }

    private static class WaypointCommand
    extends SubCommand {
        private final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        private final DeathFinderAddon addon;

        public WaypointCommand(DeathFinderAddon addon) {
            super("waypoint", new String[0]);
            this.addon = addon;
        }

        public boolean execute(String prefix, String[] arguments) {
            if (DeathFinderAddon.references().deathManager().getLocation() == null) {
                this.displayMessage(((TextComponent)Component.empty().append(DeathFinderAddon.prefix())).append((Component)Component.translatable((String)"deathfinder.command.noSavedPoint", (TextColor)NamedTextColor.RED)));
                return true;
            }
            if (!Laby.labyAPI().addonService().isEnabled("labyswaypoints")) {
                this.displayMessage(((TextComponent)Component.empty().append(DeathFinderAddon.prefix())).append((Component)Component.translatable((String)"deathfinder.command.waypoint.notEnabled", (TextColor)NamedTextColor.RED)));
                return true;
            }
            WaypointService service = Waypoints.references().waypointService();
            DeathLocation death = DeathFinderAddon.references().deathManager().getLocation();
            service.add(WaypointBuilder.create().title((Component)Component.text((String)this.getWaypointName())).type(this.getWaypointType()).location(death.toDoubleVector3()).color((Color)((DeathFinderConfig)this.addon.configuration()).waypoints().color().get()).applyCurrentContext().dimension(death.getDimension()).build());
            service.refresh();
            this.displayMessage(((TextComponent)Component.empty().append(DeathFinderAddon.prefix())).append((Component)Component.translatable((String)"deathfinder.command.waypoint.success", (TextColor)NamedTextColor.GREEN)));
            return true;
        }

        private String getWaypointName() {
            return ((String)((DeathFinderConfig)this.addon.configuration()).waypoints().title().get()).replace("{date}", this.format.format(DeathFinderAddon.references().deathManager().getLocation().getTimestamp()));
        }

        private WaypointType getWaypointType() {
            return WaypointType.valueOf((String)((com.rappytv.deathfinder.api.util.WaypointType)((Object)((DeathFinderConfig)this.addon.configuration()).waypoints().type().get())).name());
        }
    }
}

