/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.deathfinder.core.listeners;

import com.rappytv.deathfinder.api.event.DeathEvent;
import com.rappytv.deathfinder.core.DeathFinderAddon;
import com.rappytv.deathfinder.core.config.DeathFinderConfig;
import java.util.concurrent.TimeUnit;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.event.Subscribe;
import net.labymod.api.notification.Notification;
import net.labymod.api.util.concurrent.task.Task;
import net.labymod.api.util.concurrent.task.TaskBuilder;

public class DeathListener {
    private final DeathFinderAddon addon;
    private final TaskBuilder respawnTask = Task.builder(DeathFinderAddon.references().deathManager()::respawn);

    public DeathListener(DeathFinderAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onDeath(DeathEvent event) {
        if (!((Boolean)((DeathFinderConfig)this.addon.configuration()).enabled().get()).booleanValue()) {
            return;
        }
        DeathFinderAddon.references().deathManager().setLocation(event.location());
        Laby.references().chatExecutor().displayClientMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(DeathFinderAddon.prefix())).append((Component)Component.translatable((String)"deathfinder.onDeath.message", (TextColor)NamedTextColor.GREEN))).append((Component)Component.newline())).append(DeathFinderAddon.prefix())).append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY).append(((TextComponent)Component.text((String)"TP").color(NamedTextColor.RED)).decorate(TextDecoration.BOLD))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"deathfinder.onDeath.hover.teleport", (TextColor)NamedTextColor.GREEN)))).clickEvent(ClickEvent.runCommand((String)"/df back")))).append((Component)Component.text((String)" | ", (TextColor)NamedTextColor.DARK_GRAY))).append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY).append(((TextComponent)Component.text((String)"PING").color(NamedTextColor.YELLOW)).decorate(TextDecoration.BOLD))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"deathfinder.onDeath.hover.waypoint", (TextColor)NamedTextColor.GREEN)))).clickEvent(ClickEvent.runCommand((String)"/df waypoint")))).append((Component)Component.text((String)" | ", (TextColor)NamedTextColor.DARK_GRAY))).append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY).append(((TextComponent)Component.text((String)"INFOS").color(NamedTextColor.AQUA)).decorate(TextDecoration.BOLD))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"deathfinder.onDeath.hover.show", (TextColor)NamedTextColor.GREEN)))).clickEvent(ClickEvent.runCommand((String)"/df coords"))));
        if (((Boolean)((DeathFinderConfig)this.addon.configuration()).autoRespawn().get()).booleanValue()) {
            if (event.isHardcore() && !((Boolean)((DeathFinderConfig)this.addon.configuration()).autoHardcoreRespawn().get()).booleanValue()) {
                return;
            }
            int respawnDelay = (Integer)((DeathFinderConfig)this.addon.configuration()).autoRespawnDelay().get();
            Task task = this.respawnTask.delay((long)respawnDelay, TimeUnit.SECONDS).build();
            task.execute();
            Notification.builder().title((Component)Component.translatable((String)"deathfinder.onDeath.autoRespawn.title", (Component[])new Component[0])).text((Component)Component.translatable((String)"deathfinder.onDeath.autoRespawn.description", (Component[])new Component[]{Component.text((Object)respawnDelay, (TextColor)NamedTextColor.AQUA)})).duration((long)respawnDelay * 1000L).addButton(Notification.NotificationButton.of((Component)Component.translatable((String)"deathfinder.onDeath.autoRespawn.cancel", (Component[])new Component[0]), () -> ((Task)task).cancel())).buildAndPush();
        }
    }
}

