/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.deathfinder.core;

import com.rappytv.deathfinder.api.generated.ReferenceStorage;
import com.rappytv.deathfinder.core.commands.DeathFinderCommand;
import com.rappytv.deathfinder.core.config.DeathFinderConfig;
import com.rappytv.deathfinder.core.listeners.AddonEnableListener;
import com.rappytv.deathfinder.core.listeners.DeathListener;
import com.rappytv.deathfinder.core.smartchat.SmartChatManager;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.revision.Revision;
import net.labymod.api.revision.SimpleRevision;
import net.labymod.api.util.version.SemanticVersion;

@AddonMain
public class DeathFinderAddon
extends LabyAddon<DeathFinderConfig> {
    private static final Component PREFIX = ((TextComponent)Component.empty().append(((TextComponent)Component.text((String)"DF ").color(NamedTextColor.DARK_PURPLE)).decorate(TextDecoration.BOLD))).append((Component)Component.text((String)"\u00bb ", (TextColor)NamedTextColor.DARK_GRAY));
    private static ReferenceStorage referenceStorage;

    protected void preConfigurationLoad() {
        Laby.references().revisionRegistry().register((Revision)new SimpleRevision("deathfinder", new SemanticVersion("1.1.1"), "2025-09-29"));
    }

    protected void enable() {
        referenceStorage = (ReferenceStorage)this.referenceStorageAccessor();
        this.registerSettingCategory();
        this.registerCommand(new DeathFinderCommand(this));
        this.registerListener(new AddonEnableListener(this));
        this.registerListener(new DeathListener(this));
        if (Laby.labyAPI().addonService().isEnabled("smartchat")) {
            SmartChatManager.registerPlaceholders(this);
            this.logger().info((CharSequence)"Successfully registered SmartChat placeholders!", new Object[0]);
        } else {
            this.logger().info((CharSequence)"SmartChat not enabled. Skipping placeholder registration...", new Object[0]);
        }
    }

    protected Class<? extends DeathFinderConfig> configurationClass() {
        return DeathFinderConfig.class;
    }

    public static Component prefix() {
        return PREFIX.copy();
    }

    public static ReferenceStorage references() {
        return referenceStorage;
    }
}

