/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core;

import java.util.Iterator;
import java.util.Optional;
import net.labymod.addons.flux.core.FluxProvider;
import net.labymod.addons.flux.core.configuration.FluxConfiguration;
import net.labymod.addons.flux.core.debugger.DebuggerScreen;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.KeyHandler;
import net.labymod.api.client.gui.screen.widget.overlay.ScreenOverlay;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.input.KeyEvent;
import net.labymod.api.event.client.resources.pack.ResourceReloadEvent;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.service.CustomServiceLoader;
import net.labymod.core.loader.DefaultLabyModLoader;

@AddonMain
public class Flux
extends LabyAddon<FluxConfiguration> {
    public static final String NAMESPACE = "flux";
    private static FluxProvider provider;
    private static Flux instance;

    public Flux() {
        instance = this;
    }

    public static Flux get() {
        return instance;
    }

    protected void enable() {
        CustomServiceLoader providers = CustomServiceLoader.load(FluxProvider.class, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (CustomServiceLoader.ServiceType)CustomServiceLoader.ServiceType.ADVANCED);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            FluxProvider provider;
            Flux.provider = provider = (FluxProvider)iterator.next();
        }
        if (provider == null) {
            throw new IllegalStateException("No provider could be found for the current version: " + PlatformEnvironment.getRunningVersion());
        }
        this.registerSettingCategory();
        Laby.labyAPI().screenOverlayHandler().registerOverlay((ScreenOverlay)new DebuggerScreen());
    }

    private void openOrCloseDebugger() {
        Optional screenOverlay = Laby.labyAPI().screenOverlayHandler().findScreenOverlay(DebuggerScreen.class);
        if (screenOverlay.isPresent()) {
            DebuggerScreen debuggerScreen;
            debuggerScreen.setActive(!(debuggerScreen = (DebuggerScreen)((Object)screenOverlay.get())).isActive());
        }
    }

    protected Class<? extends FluxConfiguration> configurationClass() {
        return FluxConfiguration.class;
    }

    public static FluxProvider provider() {
        return provider;
    }

    public static ResourceLocation withDefaultNamespace(String path) {
        return ResourceLocation.create((String)NAMESPACE, (String)path);
    }

    @Subscribe
    public void onResourceReload(ResourceReloadEvent event) {
        FluxProvider provider = Flux.provider();
        if (provider == null) {
            return;
        }
        provider.onResourcesReload();
    }

    @Subscribe
    public void onKey(KeyEvent event) {
        if (event.state() != KeyEvent.State.PRESS) {
            return;
        }
        if (!DefaultLabyModLoader.getInstance().isAddonDevelopmentEnvironment()) {
            return;
        }
        boolean controlDown = KeyHandler.isControlDown();
        if (!controlDown) {
            return;
        }
        if (event.key() == Key.NUM3) {
            ConfigProperty<Boolean> enhancedRenderer;
            enhancedRenderer.set((Object)((Boolean)(enhancedRenderer = ((FluxConfiguration)this.configuration()).enhancedRenderer()).get() == false ? 1 : 0));
        }
        if (event.key() == Key.NUM2) {
            ConfigProperty<Boolean> fluxEnabled;
            fluxEnabled.set((Object)((Boolean)(fluxEnabled = ((FluxConfiguration)this.configuration()).enabled()).get() == false ? 1 : 0));
        }
        if (event.key() == Key.NUM1) {
            this.openOrCloseDebugger();
        }
    }
}

