/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core.debugger;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.labymod.api.Laby;
import net.labymod.api.LabyAPI;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.window.Window;

public final class Debugger {
    private static final List<Supplier<String>> ENTRIES = new ArrayList<Supplier<String>>();
    public static boolean enabled = false;

    public static void addEntry(String value) {
        Debugger.addEntry(() -> value);
    }

    public static void addEntry(Supplier<String> supplier) {
        if (!enabled) {
            return;
        }
        ENTRIES.add(supplier);
    }

    public static void render(ScreenContext context) {
        LabyAPI labyAPI = Laby.labyAPI();
        Window window = labyAPI.minecraft().minecraftWindow();
        String[] lines = new String[ENTRIES.size()];
        float maxWidth = 0.0f;
        ScreenCanvas canvas = context.canvas();
        for (int i = 0; i < ENTRIES.size(); ++i) {
            String content;
            lines[i] = content = ENTRIES.get(i).get();
            float width = canvas.getTextWidth(content);
            if (!(width > maxWidth)) continue;
            maxWidth = width;
        }
        int scaledWidth = window.getScaledWidth();
        float bottom = (float)lines.length * canvas.getLineHeight();
        canvas.submitAbsoluteRect((float)scaledWidth - (maxWidth += 4.0f), 0.0f, (float)scaledWidth, bottom += 2.0f, -2013265920);
        float y = 0.0f;
        for (String line : lines) {
            canvas.submitText(line, (float)scaledWidth - canvas.getTextWidth(line) - 2.0f, y + 2.0f, -1, 1.0f, 1);
            y += canvas.getLineHeight();
        }
        ENTRIES.clear();
    }

    public static String withLeadingZeros(int number) {
        StringBuilder string = new StringBuilder(String.valueOf(number));
        for (int i = string.length(); i < 3; ++i) {
            string.insert(0, "\u00a780\u00a7r");
        }
        return string.toString();
    }
}

