/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core.debugger;

import net.labymod.addons.flux.core.Flux;
import net.labymod.addons.flux.core.configuration.FluxConfiguration;
import net.labymod.addons.flux.core.debugger.Debugger;
import net.labymod.api.Laby;
import net.labymod.api.client.gfx.pipeline.context.FrameContext;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.widget.overlay.ScreenOverlay;
import net.labymod.core.main.profiler.RenderProfiler;

@AutoActivity
public class DebuggerScreen
extends ScreenOverlay
implements FrameContext {
    private final FluxConfiguration configuration;

    public DebuggerScreen() {
        super(0);
        this.labyAPI.gfxRenderPipeline().frameContextRegistry().register((FrameContext)this);
        this.configuration = (FluxConfiguration)Flux.get().configuration();
    }

    public void onOpenScreen() {
        super.onOpenScreen();
        Debugger.enabled = true;
    }

    public void onCloseScreen() {
        super.onCloseScreen();
        Debugger.enabled = false;
    }

    public void render(ScreenContext context) {
        super.render(context);
        Debugger.render(context);
    }

    public void beginFrame() {
    }

    public void endFrame() {
        Debugger.addEntry(() -> "FPS: " + Laby.labyAPI().minecraft().getFPS());
        Debugger.addEntry(() -> "Flux: " + ((Boolean)this.configuration.enabled().get() != false ? "\u00a7aEnabled\u00a7r" : "\u00a7cDisabled\u00a7r"));
        Debugger.addEntry(() -> "Renderer: " + (this.configuration.isEnhancedRenderer() ? "\u00a7aEnhanced" : "\u00a7cVanilla"));
        Debugger.addEntry(() -> "Render Calls: " + RenderProfiler.getRenderCalls());
    }
}

